/*
 * Decompiled with CFR 0.152.
 */
package net.hollowed.combatamenities.mixin.slots.networking;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.hollowed.combatamenities.networking.slots.SlotClientPacketPayload;
import net.hollowed.combatamenities.networking.slots.SoundPacketPayload;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3231.class})
public class EntityTrackerEntryMixin {
    @Mutable
    @Final
    @Shadow
    private final class_1297 field_14049;
    @Unique
    private static final HashMap<UUID, class_243> previousPositions = new HashMap();
    @Unique
    private final Queue<Float> verticalVelocityHistory = new LinkedList<Float>();
    @Unique
    private boolean wasOnGroundLastTick = true;

    public EntityTrackerEntryMixin(class_1297 entity) {
        this.field_14049 = entity;
    }

    @Inject(method={"startTracking"}, at={@At(value="TAIL")})
    public void startTrackingMixin(class_3222 serverPlayer, CallbackInfo info) {
        class_1297 class_12972 = this.field_14049;
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            this.sendBackSlotUpdate(serverPlayer, player);
            this.sendBackSlotUpdate(player, player);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo info) {
        class_1297 class_12972 = this.field_14049;
        if (class_12972 instanceof class_1657) {
            boolean isLanding;
            class_1657 player = (class_1657)class_12972;
            UUID playerId = player.method_5667();
            class_243 currentPosition = player.method_73189();
            class_243 previousPosition = previousPositions.getOrDefault(playerId, currentPosition);
            class_243 velocity = currentPosition.method_1020(previousPosition);
            class_1792 backStack = player.method_31548().method_5438(41).method_7909();
            if (!(backStack instanceof class_1747) && player.method_31548().method_5438(41) != class_1799.field_8037 && (isLanding = this.detectLanding(player))) {
                this.playLandingSound(player, velocity.field_1351);
            }
            int VELOCITY_HISTORY_SIZE = 5;
            if (this.verticalVelocityHistory.size() >= VELOCITY_HISTORY_SIZE) {
                this.verticalVelocityHistory.poll();
            }
            this.verticalVelocityHistory.offer(Float.valueOf((float)velocity.field_1351));
            previousPositions.put(playerId, currentPosition);
            this.wasOnGroundLastTick = player.method_24828();
        }
    }

    @Unique
    private void sendBackSlotUpdate(class_3222 recipient, class_3222 sourcePlayer) {
        class_1799 backSlotItem = sourcePlayer.method_31548().method_5438(41);
        ServerPlayNetworking.send((class_3222)recipient, (class_8710)new SlotClientPacketPayload(sourcePlayer.method_5628(), 41, backSlotItem.method_7960() ? class_1799.field_8037 : backSlotItem));
        ServerPlayNetworking.send((class_3222)recipient, (class_8710)new SlotClientPacketPayload(sourcePlayer.method_5628(), 42, sourcePlayer.method_31548().method_5438(42).method_7960() ? class_1799.field_8037 : sourcePlayer.method_31548().method_5438(42)));
    }

    @Unique
    private boolean detectLanding(class_1657 playerEntity) {
        if (playerEntity.method_24828() && !this.wasOnGroundLastTick) {
            Iterator iterator = this.verticalVelocityHistory.iterator();
            while (iterator.hasNext()) {
                float velocity = ((Float)iterator.next()).floatValue();
                if (!(velocity < -0.1f)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private void playLandingSound(class_1657 playerEntity, double verticalVelocity) {
        float volume = class_3532.method_15363((float)((float)(-verticalVelocity / 2.0)), (float)0.1f, (float)1.0f);
        if (playerEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)playerEntity;
            for (class_3222 player : serverPlayer.method_51469().method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new SoundPacketPayload(0, playerEntity.method_73189(), false, volume, 1.0f, 0, playerEntity.method_31548().method_5438(41)));
            }
        }
    }
}

