/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.api.tabs;

import com.blackgear.platform.client.event.screen.HudRendering;
import com.blackgear.platform.client.event.screen.api.ScreenAccess;
import com.blackgear.vanillabackport.client.api.tabs.BundledTabs;
import com.blackgear.vanillabackport.client.registries.ModBundledTabs;
import com.blackgear.vanillabackport.client.registries.ModCreativeTabs;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.mixin.access.CreativeModeInventoryScreenAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class BundledTabSelector {
    private static final ResourceLocation SELECTOR_BAR = VanillaBackport.resource("textures/gui/bundled_tabs/interface.png");
    private static final int VISIBLE_CATEGORIES = 5;
    private static BundledTabSelector instance;
    private int guiLeft;
    private int guiTop;
    private int scroll;
    private AbstractWidget scrollUpButton;
    private AbstractWidget scrollDownButton;
    private List<BundledTabs> bundles = null;
    private CreativeModeTab lastTab;
    private int itemCount;

    public static BundledTabSelector bootstrap() {
        if (instance == null) {
            instance = new BundledTabSelector();
        }
        return instance;
    }

    private BundledTabSelector() {
        HudRendering.POST_INITIALIZE.register(this::init);
        HudRendering.RENDER_BACKGROUND.register(this::renderBackground);
        HudRendering.CLOSE_CONTAINER.register(this::onClose);
    }

    private void init(Minecraft minecraft, Screen screen, ScreenAccess access) {
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            if (this.bundles == null) {
                ArrayList<BundledTabs> bundles = new ArrayList<BundledTabs>(ModBundledTabs.getFilters());
                Collections.reverse(bundles);
                this.bundles = bundles;
            }
            this.guiLeft = creativeScreen.f_97735_;
            this.guiTop = creativeScreen.f_97736_;
            this.injectWidgets(creativeScreen, arg_0 -> ((ScreenAccess)access).addRenderableWidget(arg_0));
            this.itemCount = ModCreativeTabs.VANILLA_BACKPORT.get().m_260957_().size();
        }
    }

    private void renderBackground(Minecraft minecraft, AbstractContainerScreen<?> screen, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            CreativeModeTab tab = CreativeModeInventoryScreenAccessor.getSelectedTab();
            if (this.isValidTab(tab)) {
                graphics.m_280218_(SELECTOR_BAR, this.guiLeft - 30, this.guiTop + 2, 0, 0, 30, 120);
                if (this.hasSelectedBundle() && ((CreativeModeInventoryScreen.ItemPickerMenu)creativeScreen.m_6262_()).f_98639_.size() == this.itemCount) {
                    this.bundles.forEach(BundledTabs::deselect);
                }
            }
            if (this.lastTab != tab) {
                this.onSwitchCreativeTab(tab, creativeScreen);
                this.lastTab = tab;
            }
        }
    }

    private void onClose(Minecraft minecraft, Screen screen) {
        if (screen instanceof CreativeModeInventoryScreen) {
            this.scrollUpButton = null;
            this.scrollDownButton = null;
            this.bundles.forEach(bundle -> {
                bundle.setContentTab(null);
                bundle.deselect();
            });
        }
    }

    private boolean hasSelectedBundle() {
        return this.bundles != null && this.bundles.stream().anyMatch(BundledTabs::isSelected);
    }

    private void injectWidgets(CreativeModeInventoryScreen screen, Consumer<AbstractWidget> widgets) {
        this.bundles.forEach(category -> {
            Tab tab = new Tab(this.guiLeft - 23, this.guiTop + 7, (BundledTabs)category, button -> {
                if (category.isSelected()) {
                    category.deselect();
                } else {
                    this.bundles.forEach(BundledTabs::deselect);
                    category.select();
                }
                this.updateItems(screen);
            });
            tab.f_93624_ = false;
            widgets.accept((AbstractWidget)tab);
        });
        this.scrollUpButton = new ScrollButton(this.guiLeft - 24, this.guiTop + 6, 32, button -> {
            if (this.scroll > 0) {
                --this.scroll;
            }
            this.updateWidgets();
        });
        this.scrollDownButton = new ScrollButton(this.guiLeft - 24, this.guiTop + 108, 52, button -> {
            if (this.scroll < this.getMaxScroll()) {
                ++this.scroll;
            }
            this.updateWidgets();
        });
        widgets.accept(this.scrollUpButton);
        widgets.accept(this.scrollDownButton);
        this.updateWidgets();
        this.onSwitchCreativeTab(CreativeModeInventoryScreenAccessor.getSelectedTab(), screen);
    }

    private int getMaxScroll() {
        return Math.max(0, this.bundles.size() - 5);
    }

    private void updateItems(CreativeModeInventoryScreen screen) {
        HashSet seen = new HashSet();
        LinkedHashSet display = new LinkedHashSet();
        boolean hasSelection = this.hasSelectedBundle();
        ModCreativeTabs.VANILLA_BACKPORT.get().m_260957_().forEach(stack -> {
            if (!hasSelection) {
                if (seen.add(stack)) {
                    display.add(stack.m_41777_());
                }
            } else {
                this.bundles.stream().filter(BundledTabs::isSelected).filter(bundle -> bundle.contains((ItemStack)stack)).findFirst().ifPresent(bundle -> {
                    if (seen.add(stack)) {
                        display.add(stack.m_41777_());
                    }
                });
            }
        });
        NonNullList items = ((CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_()).f_98639_;
        items.clear();
        items.addAll(display);
        ((CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_()).m_98642_(0.0f);
    }

    private void updateWidgets() {
        this.bundles.forEach(bundle -> bundle.setVisible(false));
        for (int i = this.scroll; i < this.scroll + 5 && i < this.bundles.size(); ++i) {
            BundledTabs bundle2 = this.bundles.get(i);
            bundle2.setY(this.guiTop + 18 * (i - this.scroll) + 18);
            bundle2.setVisible(true);
        }
        boolean isValidTab = this.isValidTab(CreativeModeInventoryScreenAccessor.getSelectedTab());
        this.scrollUpButton.f_93624_ = isValidTab && this.scroll > 0;
        this.scrollDownButton.f_93624_ = isValidTab && this.scroll < this.getMaxScroll();
    }

    private void onSwitchCreativeTab(CreativeModeTab tab, CreativeModeInventoryScreen screen) {
        if (this.isValidTab(tab)) {
            this.updateWidgets();
            this.updateItems(screen);
        } else {
            this.scrollUpButton.f_93624_ = false;
            this.scrollDownButton.f_93624_ = false;
            this.bundles.forEach(bundle -> bundle.setVisible(false));
        }
    }

    private boolean isValidTab(CreativeModeTab tab) {
        return tab == ModCreativeTabs.VANILLA_BACKPORT.get();
    }

    public static class ScrollButton
    extends Button {
        private final int uOffset;

        public ScrollButton(int x, int y, int uOffset, Button.OnPress onPress) {
            super(x, y, 18, 20, (Component)Component.m_237119_(), onPress, f_252438_);
            this.uOffset = uOffset;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int textureY = this.f_93622_ ? 12 : 0;
            graphics.m_280218_(SELECTOR_BAR, this.m_252754_(), this.m_252907_(), this.uOffset, textureY, 18, 11);
        }
    }

    public static class Tab
    extends Button {
        private final BundledTabs bundle;

        protected Tab(int x, int y, BundledTabs bundle, Button.OnPress onPress) {
            super(x, y, 16, 16, (Component)Component.m_237119_(), onPress, f_252438_);
            this.bundle = bundle;
            bundle.setContentTab(this);
            this.m_257544_(Tooltip.m_257550_((Component)bundle.getTooltip()));
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.renderSelected(graphics);
            graphics.m_280480_(this.bundle.getIcon(), this.m_252754_(), this.m_252907_());
            this.renderHighlight(graphics);
        }

        private void renderSelected(GuiGraphics graphics) {
            if (this.bundle.isSelected()) {
                graphics.m_280218_(SELECTOR_BAR, this.m_252754_() - 7, this.m_252907_() - 1, 36, 24, 30, 19);
            }
        }

        private void renderHighlight(GuiGraphics graphics) {
            if (this.m_274382_() && !this.bundle.isSelected()) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85837_(0.0, 0.0, 200.0);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                graphics.m_280218_(SELECTOR_BAR, this.m_252754_(), this.m_252907_(), 32, 44, 16, 16);
                RenderSystem.disableBlend();
                graphics.m_280168_().m_85849_();
            }
        }

        protected ClientTooltipPositioner m_262860_() {
            return DefaultTooltipPositioner.f_262752_;
        }
    }
}

