/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.particles.particleoptions;

import com.blackgear.vanillabackport.core.util.ColorUtils;
import com.blackgear.vanillabackport.core.util.codec.AdditionalCodecs;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.FastColor;

public class ColorParticleOption
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ColorParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<ColorParticleOption>(){

        public ColorParticleOption fromCommand(ParticleType<ColorParticleOption> type, StringReader reader) throws CommandSyntaxException {
            int color = reader.readInt();
            return new ColorParticleOption(type, color);
        }

        public ColorParticleOption fromNetwork(ParticleType<ColorParticleOption> type, FriendlyByteBuf buffer) {
            return new ColorParticleOption(type, buffer.readInt());
        }
    };
    private final ParticleType<ColorParticleOption> type;
    private final int color;

    public static Codec<ColorParticleOption> codec(ParticleType<ColorParticleOption> type) {
        return AdditionalCodecs.ARGB_COLOR_CODEC.xmap(integer -> new ColorParticleOption(type, (int)integer), option -> option.color).fieldOf("color").codec();
    }

    public ColorParticleOption(ParticleType<ColorParticleOption> type, int color) {
        this.type = type;
        this.color = color;
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.color);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.color);
    }

    public float getRed() {
        return (float)FastColor.ARGB32.m_13665_((int)this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)FastColor.ARGB32.m_13667_((int)this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)FastColor.ARGB32.m_13669_((int)this.color) / 255.0f;
    }

    public float getAlpha() {
        return (float)FastColor.ARGB32.m_13655_((int)this.color) / 255.0f;
    }

    public static ColorParticleOption create(ParticleType<ColorParticleOption> type, int color) {
        return new ColorParticleOption(type, color);
    }

    public static ColorParticleOption create(ParticleType<ColorParticleOption> type, float red, float green, float blue) {
        return new ColorParticleOption(type, ColorUtils.colorFromFloat(1.0f, red, green, blue));
    }
}

