/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common;

import com.blackgear.platform.common.data.LootModifier;
import com.blackgear.platform.common.integration.BlockIntegration;
import com.blackgear.platform.common.integration.MobIntegration;
import com.blackgear.platform.common.integration.MobInteraction;
import com.blackgear.platform.common.integration.TradeIntegration;
import com.blackgear.platform.common.worldgen.modifier.BiomeManager;
import com.blackgear.platform.common.worldgen.placement.BiomePlacement;
import com.blackgear.platform.core.ParallelDispatch;
import com.blackgear.platform.core.events.ResourceReloadManager;
import com.blackgear.platform.core.events.ServerLifecycleEvents;
import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.LootIntegrations;
import com.blackgear.vanillabackport.common.api.leash.LeashIntegration;
import com.blackgear.vanillabackport.common.api.wolf.WolfSoundVariants;
import com.blackgear.vanillabackport.common.level.dispenser.PaleOakBoatDispenseBehavior;
import com.blackgear.vanillabackport.common.level.entities.animal.ChickenVariants;
import com.blackgear.vanillabackport.common.level.entities.animal.CowVariants;
import com.blackgear.vanillabackport.common.level.entities.animal.PigVariants;
import com.blackgear.vanillabackport.common.level.entities.armadillo.Armadillo;
import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfVariants;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.common.resource.ChickenVariantReloadListener;
import com.blackgear.vanillabackport.common.resource.CowVariantReloadListener;
import com.blackgear.vanillabackport.common.resource.PigVariantReloadListener;
import com.blackgear.vanillabackport.common.resource.WolfSoundVariantReloadListener;
import com.blackgear.vanillabackport.common.resource.WolfVariantReloadListener;
import com.blackgear.vanillabackport.common.worldgen.BiomeGeneration;
import com.blackgear.vanillabackport.common.worldgen.WorldGeneration;
import com.blackgear.vanillabackport.core.VanillaBackport;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;

public class CommonSetup {
    public static void setup() {
        ResourceReloadManager.registerServer(event -> {
            event.register(VanillaBackport.resource("wolf_sound_variants"), (PreparableReloadListener)WolfSoundVariantReloadListener.INSTANCE);
            event.register(VanillaBackport.resource("wolf_variants"), (PreparableReloadListener)new WolfVariantReloadListener());
            event.register(VanillaBackport.resource("cow_variants"), (PreparableReloadListener)new CowVariantReloadListener());
            event.register(VanillaBackport.resource("chicken_variants"), (PreparableReloadListener)new ChickenVariantReloadListener());
            event.register(VanillaBackport.resource("pig_variants"), (PreparableReloadListener)new PigVariantReloadListener());
        });
        MobIntegration.registerIntegrations(CommonSetup::mobIntegrations);
    }

    public static void asyncSetup(ParallelDispatch dispatch) {
        dispatch.enqueueWork(() -> {
            BiomeManager.add(WorldGeneration::bootstrap);
            BiomePlacement.registerBiomePlacements(BiomeGeneration::bootstrap);
            BlockIntegration.registerIntegrations(CommonSetup::blockIntegrations);
            TradeIntegration.registerVillagerTrades(CommonSetup::tradeIntegrations);
            Parrot.f_29358_.put(ModEntities.CREAKING.get(), ModSoundEvents.PARROT_IMITATE_CREAKING.get());
        });
        MobIntegration.registerIntegrations(CommonSetup::mobPlacements);
        LootModifier.modify((LootModifier.LootTableModifier)new LootIntegrations());
        ServerLifecycleEvents.STARTING.register(server -> {
            WolfSoundVariants.bootstrap();
            WolfVariants.bootstrap((RegistryAccess)server.m_206579_());
            PigVariants.bootstrap((RegistryAccess)server.m_206579_());
            CowVariants.bootstrap((RegistryAccess)server.m_206579_());
            ChickenVariants.bootstrap((RegistryAccess)server.m_206579_());
        });
    }

    public static void blockIntegrations(BlockIntegration.Event event) {
        event.registerFuelItem((ItemLike)ModBlocks.SHORT_DRY_GRASS.get(), 100);
        event.registerFuelItem((ItemLike)ModBlocks.TALL_DRY_GRASS.get(), 100);
        event.registerFuelItem((ItemLike)ModBlocks.LEAF_LITTER.get(), 100);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_PLANKS.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_SLAB.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_FENCE_GATE.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_FENCE.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_STAIRS.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_LOG.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.STRIPPED_PALE_OAK_LOG.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.STRIPPED_PALE_OAK_WOOD.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_WOOD.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_LEAVES.get(), 30, 60);
        event.registerFlammableBlock(ModBlocks.PALE_MOSS_BLOCK.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.PALE_MOSS_CARPET.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.PALE_HANGING_MOSS.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.OPEN_EYEBLOSSOM.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.CLOSED_EYEBLOSSOM.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.BUSH.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.FIREFLY_BUSH.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.WILDFLOWERS.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.CACTUS_FLOWER.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.SHORT_DRY_GRASS.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.TALL_DRY_GRASS.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.LEAF_LITTER.get(), 60, 100);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_OAK_LEAVES.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_OAK_SAPLING.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_MOSS_CARPET.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_HANGING_MOSS.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.PALE_MOSS_BLOCK.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.BUSH.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.LEAF_LITTER.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.FIREFLY_BUSH.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.WILDFLOWERS.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.CACTUS_FLOWER.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.SHORT_DRY_GRASS.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.TALL_DRY_GRASS.get(), 0.3f);
        event.registerCompostableItem((ItemLike)ModBlocks.OPEN_EYEBLOSSOM.get(), 0.65f);
        event.registerCompostableItem((ItemLike)ModBlocks.CLOSED_EYEBLOSSOM.get(), 0.65f);
        event.registerStrippableBlock(ModBlocks.PALE_OAK_LOG.get(), ModBlocks.STRIPPED_PALE_OAK_LOG.get());
        event.registerStrippableBlock(ModBlocks.PALE_OAK_WOOD.get(), ModBlocks.STRIPPED_PALE_OAK_WOOD.get());
        event.registerDispenserBehavior((ItemLike)ModItems.PALE_OAK_BOAT.get(), (DispenseItemBehavior)new PaleOakBoatDispenseBehavior());
        event.registerDispenserBehavior((ItemLike)ModItems.PALE_OAK_CHEST_BOAT.get(), (DispenseItemBehavior)new PaleOakBoatDispenseBehavior(true));
        event.registerDispenserBehavior((ItemLike)ModItems.BLUE_EGG.get(), (DispenseItemBehavior)new DefaultDispenseItemBehavior());
        event.registerDispenserBehavior((ItemLike)ModItems.BROWN_EGG.get(), (DispenseItemBehavior)new DefaultDispenseItemBehavior());
    }

    public static void tradeIntegrations(TradeIntegration.Event event) {
        if (((Boolean)VanillaBackport.COMMON_CONFIG.hasPaleTrades.get()).booleanValue()) {
            event.registerWandererTrade(false, new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds(ModBlocks.PALE_OAK_LOG.get(), 1, 8, 4, 1)});
            event.registerWandererTrade(true, new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds(ModBlocks.OPEN_EYEBLOSSOM.get(), 1, 1, 7, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.PALE_OAK_SAPLING.get(), 5, 1, 8, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.PALE_HANGING_MOSS.get(), 1, 3, 4, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.PALE_MOSS_BLOCK.get(), 1, 2, 5, 1)});
        }
        if (((Boolean)VanillaBackport.COMMON_CONFIG.hasSpringTrades.get()).booleanValue()) {
            event.registerWandererTrade(true, new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds(ModBlocks.WILDFLOWERS.get(), 1, 1, 12, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.TALL_DRY_GRASS.get(), 1, 1, 12, 1), new VillagerTrades.ItemsForEmeralds(ModBlocks.FIREFLY_BUSH.get(), 3, 1, 12, 1)});
        }
    }

    public static void mobIntegrations(MobIntegration.Event event) {
        event.registerMobInteraction((MobInteraction)new LeashIntegration());
        event.registerAttributes(ModEntities.ARMADILLO, Armadillo::createAttributes);
        event.registerAttributes(ModEntities.CREAKING, Creaking::createAttributes);
        event.registerAttributes(ModEntities.HAPPY_GHAST, HappyGhast::createAttributes);
        event.registerGoal(EntityType.f_20493_, 1, mob -> new AvoidEntityGoal((PathfinderMob)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(EntityType.f_20513_, 1, mob -> new AvoidEntityGoal((PathfinderMob)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(EntityType.f_20459_, 3, mob -> new AvoidEntityGoal((PathfinderMob)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(EntityType.f_20568_, 3, mob -> new AvoidEntityGoal((PathfinderMob)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(mob -> mob instanceof Spider, 2, mob -> new AvoidEntityGoal((PathfinderMob)mob, Armadillo.class, 6.0f, 1.0, 1.2, entity -> !((Armadillo)((Object)((Object)entity))).isScared()));
    }

    public static void mobPlacements(MobIntegration.Event event) {
        event.registerPlacement(ModEntities.ARMADILLO, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Armadillo::checkArmadilloSpawnRules);
    }
}

