/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface RandomizableContainer
extends Container {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";

    @Nullable
    public ResourceLocation getLootTable();

    public void setLootTable(@Nullable ResourceLocation var1);

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public BlockPos m_58899_();

    @Nullable
    public Level m_58904_();

    default public boolean tryLoadLootTable(CompoundTag tag) {
        ResourceLocation lootTable = ResourceLocation.m_135820_((String)tag.m_128461_(LOOT_TABLE_TAG));
        this.setLootTable(lootTable);
        this.setLootTableSeed(tag.m_128454_(LOOT_TABLE_SEED_TAG));
        return lootTable != null;
    }

    default public boolean trySaveLootTable(CompoundTag tag) {
        ResourceLocation lootTable = this.getLootTable();
        if (lootTable == null) {
            return false;
        }
        tag.m_128359_(LOOT_TABLE_TAG, lootTable.toString());
        long seed = this.getLootTableSeed();
        if (seed != 0L) {
            tag.m_128356_(LOOT_TABLE_SEED_TAG, seed);
        }
        return true;
    }

    default public void unpackLootTable(@Nullable Player player) {
        Level level = this.m_58904_();
        BlockPos origin = this.m_58899_();
        ResourceLocation lootTable = this.getLootTable();
        if (lootTable != null && level != null && level.m_7654_() != null) {
            LootTable loot = level.m_7654_().m_278653_().m_278676_(lootTable);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CriteriaTriggers.f_10563_.m_54597_(sp, lootTable);
            }
            this.setLootTable(null);
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)origin));
            if (player != null) {
                builder.m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player);
            }
            loot.m_287188_((Container)this, builder.m_287235_(LootContextParamSets.f_81411_), this.getLootTableSeed());
        }
    }
}

