/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.animal;

import com.blackgear.platform.core.Environment;
import com.blackgear.vanillabackport.common.api.variant.BiomeCheck;
import com.blackgear.vanillabackport.common.api.variant.ClientsideSpawnPrioritySelector;
import com.blackgear.vanillabackport.common.api.variant.ModelAndTexture;
import com.blackgear.vanillabackport.common.api.variant.SpawnPrioritySelectors;
import com.blackgear.vanillabackport.common.level.entities.animal.PigVariant;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBiomeTags;
import com.blackgear.vanillabackport.core.registries.ModBuiltinRegistries;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class PigVariants {
    public static final ResourceKey<PigVariant> TEMPERATE = PigVariants.register("temperate", PigVariant.ModelType.NORMAL, "pig", SpawnPrioritySelectors.fallback(0));
    public static final ResourceKey<PigVariant> WARM = PigVariants.register("warm", PigVariant.ModelType.NORMAL, "warm_pig", ModBiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
    public static final ResourceKey<PigVariant> COLD = PigVariants.register("cold", PigVariant.ModelType.COLD, "cold_pig", ModBiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);

    public static void bootstrap(RegistryAccess access) {
        PigVariants.register("temperate", PigVariant.ModelType.NORMAL, "pig", SpawnPrioritySelectors.fallback(0));
        PigVariants.register(access, "warm", PigVariant.ModelType.NORMAL, "warm_pig", ModBiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        PigVariants.register(access, "cold", PigVariant.ModelType.COLD, "cold_pig", ModBiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(RegistryAccess access, String key, PigVariant.ModelType type, String assetId, TagKey<Biome> biome) {
        access.m_254861_(Registries.f_256952_).ifPresent(lookup -> PigVariants.register(key, type, assetId, SpawnPrioritySelectors.single(new BiomeCheck((HolderSet<Biome>)lookup.m_254956_(biome)), 1)));
    }

    private static ResourceKey<PigVariant> register(String key, PigVariant.ModelType type, String assetId, TagKey<Biome> biome) {
        return PigVariants.register(key, type, assetId, SpawnPrioritySelectors.single(new BiomeCheck(PigVariants.getRequiredBiomes(biome)), 1));
    }

    private static HolderSet<Biome> getRequiredBiomes(TagKey<Biome> biome) {
        return Environment.isClientSide() ? ClientsideSpawnPrioritySelector.getRequiredBiomes(biome) : ((HolderLookup.RegistryLookup)((MinecraftServer)Environment.getCurrentServer().get()).m_206579_().m_254861_(Registries.f_256952_).get()).m_254956_(biome);
    }

    private static ResourceKey<PigVariant> register(String key, PigVariant.ModelType type, String assetId, SpawnPrioritySelectors selectors) {
        ResourceLocation path = VanillaBackport.vanilla("entity/pig/" + assetId);
        return ModBuiltinRegistries.PIG_VARIANTS.resource(key, (Object)new PigVariant(new ModelAndTexture<PigVariant.ModelType>(type, path), selectors));
    }
}

