/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.wolf;

import com.blackgear.platform.core.Environment;
import com.blackgear.vanillabackport.common.api.variant.BiomeCheck;
import com.blackgear.vanillabackport.common.api.variant.ClientAsset;
import com.blackgear.vanillabackport.common.api.variant.ClientsideSpawnPrioritySelector;
import com.blackgear.vanillabackport.common.api.variant.SpawnPrioritySelectors;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfVariant;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBiomeTags;
import com.blackgear.vanillabackport.core.registries.ModBuiltinRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class WolfVariants {
    public static final ResourceKey<WolfVariant> PALE = WolfVariants.register("pale", "wolf", SpawnPrioritySelectors.fallback(0));
    public static final ResourceKey<WolfVariant> SPOTTED = WolfVariants.register("spotted", "wolf_spotted", ModBiomeTags.SPAWNS_SPOTTED_WOLVES);
    public static final ResourceKey<WolfVariant> SNOWY = WolfVariants.register("snowy", "wolf_snowy", ModBiomeTags.SPAWNS_SNOWY_WOLVES);
    public static final ResourceKey<WolfVariant> BLACK = WolfVariants.register("black", "wolf_black", ModBiomeTags.SPAWNS_BLACK_WOLVES);
    public static final ResourceKey<WolfVariant> ASHEN = WolfVariants.register("ashen", "wolf_ashen", ModBiomeTags.SPAWNS_ASHEN_WOLVES);
    public static final ResourceKey<WolfVariant> RUSTY = WolfVariants.register("rusty", "wolf_rusty", ModBiomeTags.SPAWNS_RUSTY_WOLVES);
    public static final ResourceKey<WolfVariant> WOODS = WolfVariants.register("woods", "wolf_woods", ModBiomeTags.SPAWNS_WOOD_WOLVES);
    public static final ResourceKey<WolfVariant> CHESTNUT = WolfVariants.register("chestnut", "wolf_chestnut", ModBiomeTags.SPAWNS_CHESTNUT_WOLVES);
    public static final ResourceKey<WolfVariant> STRIPED = WolfVariants.register("striped", "wolf_striped", ModBiomeTags.SPAWNS_STRIPED_WOLVES);

    public static void bootstrap(RegistryAccess access) {
        WolfVariants.register("pale", "wolf", SpawnPrioritySelectors.fallback(0));
        WolfVariants.register(access, "spotted", "wolf_spotted", (TagKey<Biome>)BiomeTags.f_215816_);
        WolfVariants.register(access, "snowy", "wolf_snowy", (ResourceKey<Biome>)Biomes.f_186755_);
        WolfVariants.register(access, "black", "wolf_black", (ResourceKey<Biome>)Biomes.f_186763_);
        WolfVariants.register(access, "ashen", "wolf_ashen", (ResourceKey<Biome>)Biomes.f_48152_);
        WolfVariants.register(access, "rusty", "wolf_rusty", (TagKey<Biome>)BiomeTags.f_207610_);
        WolfVariants.register(access, "woods", "wolf_woods", (ResourceKey<Biome>)Biomes.f_48205_);
        WolfVariants.register(access, "chestnut", "wolf_chestnut", (ResourceKey<Biome>)Biomes.f_186764_);
        WolfVariants.register(access, "striped", "wolf_striped", (TagKey<Biome>)BiomeTags.f_207607_);
    }

    private static HolderSet<Biome> getRequiredBiomes(TagKey<Biome> biome) {
        return Environment.isClientSide() ? ClientsideSpawnPrioritySelector.getRequiredBiomes(biome) : ((HolderLookup.RegistryLookup)((MinecraftServer)Environment.getCurrentServer().get()).m_206579_().m_254861_(Registries.f_256952_).get()).m_254956_(biome);
    }

    private static Holder<Biome> getRequiredBiomes(ResourceKey<Biome> biome) {
        return Environment.isClientSide() ? ClientsideSpawnPrioritySelector.getRequiredBiomes(biome) : ((HolderLookup.RegistryLookup)((MinecraftServer)Environment.getCurrentServer().get()).m_206579_().m_254861_(Registries.f_256952_).get()).m_255043_(biome);
    }

    private static SpawnPrioritySelectors highPriorityBiome(HolderSet<Biome> biomes) {
        return SpawnPrioritySelectors.single(new BiomeCheck(biomes), 1);
    }

    private static void register(RegistryAccess access, String key, String assetId, ResourceKey<Biome> biome) {
        access.m_254861_(Registries.f_256952_).ifPresent(lookup -> WolfVariants.register(key, assetId, WolfVariants.highPriorityBiome((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{lookup.m_255043_(biome)}))));
    }

    private static void register(RegistryAccess access, String key, String assetId, TagKey<Biome> biome) {
        access.m_254861_(Registries.f_256952_).ifPresent(lookup -> WolfVariants.register(key, assetId, WolfVariants.highPriorityBiome((HolderSet<Biome>)lookup.m_254956_(biome))));
    }

    private static ResourceKey<WolfVariant> register(String key, String assetId, ResourceKey<Biome> biome) {
        return WolfVariants.register(key, assetId, WolfVariants.highPriorityBiome((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{WolfVariants.getRequiredBiomes(biome)})));
    }

    private static ResourceKey<WolfVariant> register(String key, String assetId, TagKey<Biome> biome) {
        return WolfVariants.register(key, assetId, WolfVariants.highPriorityBiome(WolfVariants.getRequiredBiomes(biome)));
    }

    private static ResourceKey<WolfVariant> register(String key, String assetId, SpawnPrioritySelectors selectors) {
        ResourceLocation wild = VanillaBackport.vanilla("entity/wolf/" + assetId);
        ResourceLocation tame = VanillaBackport.vanilla("entity/wolf/" + assetId + "_tame");
        ResourceLocation angry = VanillaBackport.vanilla("entity/wolf/" + assetId + "_angry");
        return ModBuiltinRegistries.WOLF_VARIANTS.resource(key, (Object)new WolfVariant(new WolfVariant.AssetInfo(new ClientAsset(wild), new ClientAsset(tame), new ClientAsset(angry)), selectors));
    }
}

