/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.features;

import com.blackgear.vanillabackport.common.level.features.FallenTreeConfiguration;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class FallenTreeFeature
extends Feature<FallenTreeConfiguration> {
    public FallenTreeFeature(Codec<FallenTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FallenTreeConfiguration> context) {
        this.placeFallenTree((FallenTreeConfiguration)context.m_159778_(), context.m_159777_(), context.m_159774_(), context.m_225041_());
        return true;
    }

    private void placeFallenTree(FallenTreeConfiguration config, BlockPos pos, WorldGenLevel level, RandomSource random) {
        this.placeStump(config, level, random, pos.m_122032_());
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        int length = config.logLength.m_214085_(random) - 2;
        BlockPos.MutableBlockPos mutable = pos.m_5484_(direction, 2 + random.m_188503_(2)).m_122032_();
        this.setGroundHeightForFallenLogStartPos(level, mutable);
        if (this.canPlaceEntireFallenLog(level, length, mutable, direction)) {
            this.placeFallenLog(config, level, random, length, mutable, direction);
        }
    }

    private void setGroundHeightForFallenLogStartPos(WorldGenLevel level, BlockPos.MutableBlockPos mutable) {
        mutable.m_122175_(Direction.UP, 1);
        for (int i = 0; i < 6; ++i) {
            if (this.mayPlaceOn((LevelAccessor)level, (BlockPos)mutable)) {
                return;
            }
            mutable.m_122173_(Direction.DOWN);
        }
    }

    private void placeStump(FallenTreeConfiguration config, WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos mutable) {
        BlockPos origin = this.placeLogBlock(config, level, random, mutable, Function.identity());
        this.decorateLogs(level, random, Set.of(origin), config.stumpDecorators);
    }

    private boolean canPlaceEntireFallenLog(WorldGenLevel level, int length, BlockPos.MutableBlockPos mutable, Direction direction) {
        int gaps = 0;
        for (int k = 0; k < length; ++k) {
            if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)mutable)) {
                return false;
            }
            if (!this.isOverSolidGround((LevelAccessor)level, (BlockPos)mutable)) {
                if (gaps++ > 2) {
                    return false;
                }
            } else {
                gaps = 0;
            }
            mutable.m_122173_(direction);
        }
        mutable.m_122175_(direction.m_122424_(), length);
        return true;
    }

    private void placeFallenLog(FallenTreeConfiguration config, WorldGenLevel level, RandomSource random, int length, BlockPos.MutableBlockPos mutable, Direction direction) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int i = 0; i < length; ++i) {
            positions.add(this.placeLogBlock(config, level, random, mutable, FallenTreeFeature.getSidewaysStateModifier(direction)));
            mutable.m_122173_(direction);
        }
        this.decorateLogs(level, random, positions, config.logDecorators);
    }

    private boolean mayPlaceOn(LevelAccessor level, BlockPos pos) {
        return TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos) && this.isOverSolidGround(level, pos);
    }

    private boolean isOverSolidGround(LevelAccessor level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP);
    }

    private BlockPos placeLogBlock(FallenTreeConfiguration config, WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos mutable, Function<BlockState, BlockState> factory) {
        level.m_7731_((BlockPos)mutable, factory.apply(config.trunkProvider.m_213972_(random, (BlockPos)mutable)), 3);
        this.m_159739_(level, (BlockPos)mutable);
        return mutable.m_7949_();
    }

    private void decorateLogs(WorldGenLevel level, RandomSource random, Set<BlockPos> positions, List<TreeDecorator> decorators) {
        if (!decorators.isEmpty()) {
            TreeDecorator.Context context = new TreeDecorator.Context((LevelSimulatedReader)level, this.getDecorationSetter(level), random, positions, Set.of(), Set.of());
            decorators.forEach(decorator -> decorator.m_214187_(context));
        }
    }

    private BiConsumer<BlockPos, BlockState> getDecorationSetter(WorldGenLevel level) {
        return (pos, state) -> level.m_7731_(pos, state, 19);
    }

    private static Function<BlockState, BlockState> getSidewaysStateModifier(Direction direction) {
        return state -> (BlockState)state.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
    }
}

