/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.client.entities.renderer;

import com.blackgear.vanillabackport.client.level.entities.variant.PigVariantRenderer;
import com.blackgear.vanillabackport.core.ModChecker;
import com.blackgear.vanillabackport.core.mixin.client.entities.renderer.MobRendererMixin;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PigRenderer.class})
public abstract class PigRendererMixin
extends MobRendererMixin<Pig, PigModel<Pig>> {
    @Unique
    private PigVariantRenderer renderer;

    public PigRendererMixin(EntityRendererProvider.Context context, PigModel<Pig> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Unique
    private PigVariantRenderer renderer() {
        if (this.renderer == null) {
            this.renderer = new PigVariantRenderer(this.context);
        }
        return this.renderer;
    }

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Pig;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$getTextureLocation(Pig entity, CallbackInfoReturnable<ResourceLocation> cir) {
        if (this.renderer().getTexture(entity) != null) {
            cir.setReturnValue((Object)this.renderer().getTexture(entity));
        }
    }

    public void render(Pig entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!ModChecker.MIXED_LITTER_LOADED) {
            this.f_115290_ = (EntityModel)this.renderer().getModel(entity).orElseGet(() -> (PigModel)this.defaultModel);
        }
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

