/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpawnExtras {
    public static final SpawnUtil.Strategy ON_TOP_OF_COLLIDER_NO_LEAVES = (level, pos, target, mutable, state) -> state.m_60812_((BlockGetter)level, mutable).m_83281_() && !target.m_204336_(BlockTags.f_13035_) && Block.m_49918_((VoxelShape)target.m_60812_((BlockGetter)level, pos), (Direction)Direction.UP);

    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> entityType, MobSpawnType spawnType, ServerLevel level, BlockPos pos, int attempts, int spread, int yOffset, SpawnUtil.Strategy strategy, boolean checkForCollisions) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i = 0; i < attempts; ++i) {
            Mob mob;
            int xOffset = Mth.m_216287_((RandomSource)level.f_46441_, (int)(-spread), (int)spread);
            int zOffset = Mth.m_216287_((RandomSource)level.f_46441_, (int)(-spread), (int)spread);
            mutable.m_122154_((Vec3i)pos, xOffset, yOffset, zOffset);
            if (!level.m_6857_().m_61937_((BlockPos)mutable) || !SpawnExtras.moveToPossibleSpawnPosition(level, yOffset, mutable, strategy) || checkForCollisions && !level.m_45772_(entityType.m_20585_((double)mutable.m_123341_() + 0.5, (double)mutable.m_123342_(), (double)mutable.m_123343_() + 0.5)) || (mob = (Mob)entityType.m_262451_(level, null, null, (BlockPos)mutable, spawnType, false, false)) == null) continue;
            if (mob.m_5545_((LevelAccessor)level, spawnType) && mob.m_6914_((LevelReader)level)) {
                level.m_47205_((Entity)mob);
                mob.m_8032_();
                return Optional.of(mob);
            }
            mob.m_146870_();
        }
        return Optional.empty();
    }

    private static boolean moveToPossibleSpawnPosition(ServerLevel level, int yOffset, BlockPos.MutableBlockPos pos, SpawnUtil.Strategy strategy) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        BlockState state = level.m_8055_((BlockPos)mutable);
        for (int i = yOffset; i >= -yOffset; --i) {
            pos.m_122173_(Direction.DOWN);
            mutable.m_122159_((Vec3i)pos, Direction.UP);
            BlockState target = level.m_8055_((BlockPos)pos);
            if (strategy.m_216427_(level, (BlockPos)pos, target, (BlockPos)mutable, state)) {
                pos.m_122173_(Direction.UP);
                return true;
            }
            state = target;
        }
        return false;
    }
}

