/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.client.ber;

import com.akciater.blocks.Shelf;
import com.akciater.blocks.ShelfBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class ShelfBER
implements BlockEntityRenderer<ShelfBlockEntity> {
    public List<Vec3> itemPositions = new ArrayList<Vec3>(List.of(new Vec3(0.265625, 0.265625, 0.5625), new Vec3(0.734375, 0.265625, 0.5625), new Vec3(0.265625, 0.734375, 0.5625), new Vec3(0.734375, 0.734375, 0.5625)));
    public List<Vec3> blockPositions = new ArrayList<Vec3>(List.of(new Vec3((double)0.278325f, (double)0.2627f, 0.75), new Vec3((double)0.721675f, (double)0.2627f, 0.75), new Vec3((double)0.278325f, (double)0.7373f, 0.75), new Vec3((double)0.721675f, (double)0.7373f, 0.75)));

    public Quaternionf getRotation(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> Axis.YP.rotationDegrees(0.0f);
            case Direction.EAST -> Axis.YP.rotationDegrees(270.0f);
            case Direction.SOUTH -> Axis.YP.rotationDegrees(180.0f);
            case Direction.WEST -> Axis.YP.rotationDegrees(90.0f);
            default -> null;
        };
    }

    public ShelfBER(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ShelfBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level world = entity.getLevel();
        BlockState state = world.getBlockState(entity.getBlockPos());
        if (state.getBlock() == Blocks.AIR) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Quaternionf quaternionf = this.getRotation((Direction)state.getValue(Shelf.FACING));
        int blockSize = 1;
        boolean itemSize = true;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = (ItemStack)entity.inv.get(i);
            if (stack.isEmpty()) continue;
            Vec3 pos = stack.getItem() instanceof BlockItem ? this.blockPositions.get(i) : this.itemPositions.get(i);
            poseStack.pushPose();
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(quaternionf);
            poseStack.translate(-0.5, 0.0, -0.5);
            poseStack.translate(pos.x, pos.y - 0.40625 * (double)(1 - blockSize) / 2.0, pos.z);
            boolean fullBlock = stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock().defaultBlockState().isCollisionShapeFullBlock((BlockGetter)entity.getLevel(), entity.getBlockPos());
            float scale = fullBlock ? 0.8125f : 0.40625f;
            poseStack.scale(scale * (float)blockSize, scale * (float)blockSize, scale * (float)blockSize);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, entity.getLevel(), 1);
            poseStack.popPose();
        }
    }
}

