/*
 * Decompiled with CFR 0.152.
 */
package com.akciater;

import com.akciater.blocks.FloorShelf;
import com.akciater.blocks.FloorShelfBlockEntity;
import com.akciater.blocks.Shelf;
import com.akciater.blocks.ShelfBlockEntity;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public final class ShelfModCommon {
    public static final String MODID = "shelfmod";
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MODID));
    public static final Registrar<class_2248> blocks = MANAGER.get().get(class_7924.field_41254);
    public static final Registrar<class_1792> items = MANAGER.get().get(class_7924.field_41197);
    public static final Registrar<class_2591<?>> blockEntities = MANAGER.get().get(class_7924.field_41255);
    public static final Registrar<class_1761> itemGroups = MANAGER.get().get(class_7924.field_44688);
    public static RegistrySupplier<class_1792> ICON;
    public static RegistrySupplier<class_2591<ShelfBlockEntity>> SHELF_BLOCK_ENTITY;
    public static RegistrySupplier<class_2591<FloorShelfBlockEntity>> FLOOR_SHELF_BLOCK_ENTITY;
    public static RegistrySupplier<class_1761> SHELF_MOD_TAB;
    public static List<RegistrySupplier<class_2248>> SHELVES_BLOCK;
    public static List<RegistrySupplier<class_1792>> SHELVES_ITEM;
    public static List<RegistrySupplier<class_2248>> FLOOR_SHELVES_BLOCK;
    public static List<RegistrySupplier<class_1792>> FLOOR_SHELVES_ITEM;
    public static List<JsonObject> SHELVES_JSON;
    public static List<String> MATERIALS;

    public static boolean isShelf(class_1792 item) {
        for (RegistrySupplier<class_1792> shelf : SHELVES_ITEM) {
            if (shelf.get() != item) continue;
            return true;
        }
        for (RegistrySupplier<class_1792> shelf : FLOOR_SHELVES_ITEM) {
            if (shelf.get() != item) continue;
            return true;
        }
        return false;
    }

    public static JsonObject createShapedRecipeJson(ArrayList<Character> keys, ArrayList<class_2960> items, ArrayList<String> type, ArrayList<String> pattern, class_2960 output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        json.addProperty("category", "misc");
        JsonArray jsonArray = new JsonArray();
        for (String line : pattern) {
            jsonArray.add(line);
        }
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            keyList.addProperty(keys.get(i).toString(), items.get(i).toString());
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)1);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createShelfRecipe(String material) {
        class_2960 shelf = class_2960.method_60655((String)MODID, (String)("shelf_item_" + material));
        return ShelfModCommon.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('_')}), Lists.newArrayList((Object[])new class_2960[]{class_2960.method_60654((String)(material + "_fence")), class_2960.method_60654((String)(material + "_slab"))}), Lists.newArrayList((Object[])new String[]{"item", "item"}), Lists.newArrayList((Object[])new String[]{"___", "# #", "___"}), shelf);
    }

    public static JsonObject createFloorShelfRecipe(String material) {
        class_2960 shelf = class_2960.method_60655((String)MODID, (String)("floor_shelf_item_" + material));
        return ShelfModCommon.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('@')}), Lists.newArrayList((Object[])new class_2960[]{class_2960.method_60654((String)(material + "_fence")), class_2960.method_60654((String)(material + "_planks"))}), Lists.newArrayList((Object[])new String[]{"item", "item"}), Lists.newArrayList((Object[])new String[]{"@#@", "#@#", "@#@"}), shelf);
    }

    public static void registerShelves() {
        for (int i = 0; i < MATERIALS.size(); ++i) {
            class_2960 location = class_2960.method_60655((String)MODID, (String)("shelf_" + MATERIALS.get(i)));
            class_5321 shelf_key = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)location);
            RegistrySupplier shelf = blocks.register(location, () -> new Shelf(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_63500(shelf_key)));
            SHELVES_BLOCK.add((RegistrySupplier<class_2248>)shelf);
            class_2960 itemLocation = class_2960.method_60655((String)MODID, (String)("shelf_item_" + MATERIALS.get(i)));
            class_5321 shelf_item_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)itemLocation);
            RegistrySupplier shelf_item = items.register(itemLocation, () -> new class_1747((class_2248)shelf.get(), new class_1792.class_1793().arch$tab(SHELF_MOD_TAB).method_63686(shelf_item_key)));
            SHELVES_ITEM.add((RegistrySupplier<class_1792>)shelf_item);
        }
    }

    public static void registerFloorShelves() {
        for (int i = 0; i < MATERIALS.size(); ++i) {
            class_2960 location = class_2960.method_60655((String)MODID, (String)("floor_shelf_" + MATERIALS.get(i)));
            class_5321 shelf_key = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)location);
            RegistrySupplier floor_shelf = blocks.register(location, () -> new FloorShelf(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_63500(shelf_key)));
            FLOOR_SHELVES_BLOCK.add((RegistrySupplier<class_2248>)floor_shelf);
            class_2960 itemLocation = class_2960.method_60655((String)MODID, (String)("floor_shelf_item_" + MATERIALS.get(i)));
            class_5321 floor_shelf_item_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)itemLocation);
            RegistrySupplier floor_shelf_item = items.register(itemLocation, () -> new class_1747((class_2248)floor_shelf.get(), new class_1792.class_1793().arch$tab(SHELF_MOD_TAB).method_63686(floor_shelf_item_key)));
            FLOOR_SHELVES_ITEM.add((RegistrySupplier<class_1792>)floor_shelf_item);
        }
    }

    public static void generateBlockItemModels(List<RegistrySupplier<class_1792>> items, List<RegistrySupplier<class_2248>> blocks) {
        Path outputPath = Paths.get("resources/assets/shelfmod/models/item", new String[0]);
        try {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < blocks.size(); ++i) {
            String filename = ((class_1792)items.get(i).get()).arch$registryName().method_12832();
            Path file = outputPath.resolve(filename + ".json");
            JsonObject parent = new JsonObject();
            parent.addProperty("parent", "shelfmod:block/" + ((class_2248)blocks.get(i).get()).arch$registryName().method_12832());
            String string = "resources/assets/shelfmod/models/item/" + filename + ".json";
        }
    }

    public static void initializeServer() {
        class_5321 iconKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)MODID, (String)"icon"));
        ICON = items.register(class_2960.method_60655((String)MODID, (String)"icon"), () -> new class_1792(new class_1792.class_1793().method_63686(iconKey)));
        SHELF_MOD_TAB = itemGroups.register(class_2960.method_60655((String)MODID, (String)"shelf_mod_tab"), () -> CreativeTabRegistry.create((class_2561)class_2561.method_43470((String)"Shelf mod"), () -> ((class_1792)ICON.get()).method_8389().method_7854()));
        ShelfModCommon.registerShelves();
        ShelfModCommon.registerFloorShelves();
        SHELVES_JSON = new ArrayList<JsonObject>();
        for (String material : MATERIALS) {
            SHELVES_JSON.add(ShelfModCommon.createShelfRecipe(material));
            SHELVES_JSON.add(ShelfModCommon.createFloorShelfRecipe(material));
        }
    }

    static {
        SHELVES_BLOCK = new ArrayList<RegistrySupplier<class_2248>>();
        SHELVES_ITEM = new ArrayList<RegistrySupplier<class_1792>>();
        FLOOR_SHELVES_BLOCK = new ArrayList<RegistrySupplier<class_2248>>();
        FLOOR_SHELVES_ITEM = new ArrayList<RegistrySupplier<class_1792>>();
        MATERIALS = List.of("oak", "acacia", "birch", "dark_oak", "spruce", "jungle", "mangrove", "bamboo", "warped", "cherry", "crimson");
    }
}

