/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.blocks;

import com.akciater.ShelfModCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfBlockEntity
extends BlockEntity {
    public NonNullList<ItemStack> inv = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);

    public ShelfBlockEntity(BlockPos pos, BlockState blockState) {
        super(ShelfModCommon.SHELF_BLOCK_ENTITY, pos, blockState);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        ContainerHelper.loadAllItems((ValueInput)input, this.inv);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        ContainerHelper.saveAllItems((ValueOutput)output, this.inv);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    public void markDirty() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.inv) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        ShelfBlockEntity entity = (ShelfBlockEntity)this.level.getBlockEntity(pos);
        if (entity != null && !entity.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                ItemStack itemStack = (ItemStack)entity.inv.get(i);
                if (itemStack.isEmpty()) continue;
                Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack);
            }
            entity.inv.clear();
            entity.setRemoved();
            this.level.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
        super.preRemoveSideEffects(pos, state);
    }
}

