/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.client.ber;

import com.akciater.blocks.FloorShelf;
import com.akciater.blocks.FloorShelfBlockEntity;
import com.akciater.client.ber.ShelfBERS;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FloorShelfBER
implements BlockEntityRenderer<FloorShelfBlockEntity, ShelfBERS> {
    public List<Vec3> positions = new ArrayList<Vec3>(List.of(new Vec3(0.265625, (double)0.275f, 0.265625), new Vec3(0.734375, (double)0.275f, 0.265625), new Vec3(0.265625, (double)0.275f, 0.734375), new Vec3(0.734375, (double)0.275f, 0.734375)));
    private static final Logger LOGGER = Logger.getLogger("ShelfMod");
    private final ItemModelResolver itemModelResolver;

    public Quaternionf getRotation(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> Axis.YP.rotationDegrees(0.0f);
            case Direction.EAST -> Axis.YP.rotationDegrees(270.0f);
            case Direction.SOUTH -> Axis.YP.rotationDegrees(180.0f);
            case Direction.WEST -> Axis.YP.rotationDegrees(90.0f);
            default -> null;
        };
    }

    @NotNull
    public ShelfBERS createRenderState() {
        return new ShelfBERS();
    }

    public void extractRenderState(FloorShelfBlockEntity blockEntity, ShelfBERS renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.facing = (Direction)blockEntity.getBlockState().getValue(FloorShelf.FACING);
        renderState.items = new ArrayList<ItemStackRenderState>(blockEntity.inv.size());
        renderState.fullBlock = new ArrayList<Boolean>(blockEntity.inv.size());
        int j = (int)blockEntity.getBlockPos().asLong();
        for (int i = 0; i < blockEntity.inv.size(); ++i) {
            renderState.fullBlock.add(((ItemStack)blockEntity.inv.get(i)).getItem() instanceof BlockItem && ((BlockItem)((ItemStack)blockEntity.inv.get(i)).getItem()).getBlock().defaultBlockState().isCollisionShapeFullBlock((BlockGetter)blockEntity.getLevel(), blockEntity.getBlockPos()));
            ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemStackRenderState, (ItemStack)blockEntity.inv.get(i), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, i + j);
            renderState.items.add(itemStackRenderState);
        }
    }

    public FloorShelfBER(BlockEntityRendererProvider.Context ctx) {
        this.itemModelResolver = ctx.itemModelResolver();
    }

    public void submit(ShelfBERS renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        Quaternionf quaternionf = this.getRotation(renderState.facing);
        float blockSize = 1.0f;
        for (int i = 0; i < 4; ++i) {
            ItemStackRenderState irs = renderState.items.get(i);
            if (irs.isEmpty()) continue;
            Vec3 pos = this.positions.get(i);
            poseStack.pushPose();
            poseStack.translate(pos.x, pos.y - 0.40625 * (double)(1.0f - blockSize) / 2.0, pos.z);
            float scale = renderState.fullBlock.get(i) != false ? 0.8125f : 0.40625f;
            poseStack.scale(scale * blockSize, scale * blockSize, scale * blockSize);
            poseStack.mulPose((Quaternionfc)quaternionf);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            irs.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }
}

