/*
 * Decompiled with CFR 0.152.
 */
package com.akciater;

import com.akciater.blocks.FloorShelf;
import com.akciater.blocks.FloorShelfBlockEntity;
import com.akciater.blocks.Shelf;
import com.akciater.blocks.ShelfBlockEntity;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import dev.architectury.registry.registries.RegistrySupplier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_4970;

public final class ShelfModCommon {
    public static final String MODID = "shelfmod";
    public static final Supplier<Registries> MANAGER = Suppliers.memoize(() -> Registries.get((String)MODID));
    public static final Registrar<class_2248> blocks = MANAGER.get().get(class_2378.field_25105);
    public static final Registrar<class_1792> items = MANAGER.get().get(class_2378.field_25108);
    public static final Registrar<class_2591<?>> blockEntities = MANAGER.get().get(class_2378.field_25073);
    public static RegistrySupplier<class_1792> ICON;
    public static RegistrySupplier<class_2591<ShelfBlockEntity>> SHELF_BLOCK_ENTITY;
    public static RegistrySupplier<class_2591<FloorShelfBlockEntity>> FLOOR_SHELF_BLOCK_ENTITY;
    public static class_1761 SHELF_MOD_TAB;
    public static List<RegistrySupplier<class_2248>> SHELVES_BLOCK;
    public static List<RegistrySupplier<class_1792>> SHELVES_ITEM;
    public static List<RegistrySupplier<class_2248>> FLOOR_SHELVES_BLOCK;
    public static List<RegistrySupplier<class_1792>> FLOOR_SHELVES_ITEM;
    public static List<JsonObject> SHELVES_JSON;
    public static List<String> MATERIALS;

    public static boolean isShelf(class_1792 item) {
        for (RegistrySupplier<class_1792> shelf : SHELVES_ITEM) {
            if (shelf.get() != item) continue;
            return true;
        }
        for (RegistrySupplier<class_1792> shelf : FLOOR_SHELVES_ITEM) {
            if (shelf.get() != item) continue;
            return true;
        }
        return false;
    }

    public static JsonObject createShapedRecipeJson(ArrayList<Character> keys, ArrayList<class_2960> items, ArrayList<String> type, ArrayList<String> pattern, class_2960 output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        json.addProperty("category", "misc");
        JsonArray jsonArray = new JsonArray();
        for (String line : pattern) {
            jsonArray.add(line);
        }
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(type.get(i), items.get(i).toString());
            keyList.add(keys.get(i).toString(), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("item", output.toString());
        result.addProperty("count", (Number)1);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createShelfRecipe(String material) {
        class_2960 shelf = new class_2960(MODID, "shelf_item_" + material);
        return ShelfModCommon.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('_')}), Lists.newArrayList((Object[])new class_2960[]{new class_2960(material + "_fence"), new class_2960(material + "_slab")}), Lists.newArrayList((Object[])new String[]{"item", "item"}), Lists.newArrayList((Object[])new String[]{"___", "# #", "___"}), shelf);
    }

    public static JsonObject createFloorShelfRecipe(String material) {
        class_2960 shelf = new class_2960(MODID, "floor_shelf_item_" + material);
        return ShelfModCommon.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('@')}), Lists.newArrayList((Object[])new class_2960[]{new class_2960(material + "_fence"), new class_2960(material + "_planks")}), Lists.newArrayList((Object[])new String[]{"item", "item"}), Lists.newArrayList((Object[])new String[]{"@#@", "#@#", "@#@"}), shelf);
    }

    public static void registerShelves() {
        for (int i = 0; i < MATERIALS.size(); ++i) {
            class_2960 location = new class_2960(MODID, "shelf_" + MATERIALS.get(i));
            RegistrySupplier shelf = blocks.register(location, () -> new Shelf(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(0.5f, 3.0f).method_9626(class_2498.field_11547)));
            SHELVES_BLOCK.add((RegistrySupplier<class_2248>)shelf);
            class_2960 itemLocation = new class_2960(MODID, "shelf_item_" + MATERIALS.get(i));
            RegistrySupplier shelf_item = items.register(itemLocation, () -> new class_1747((class_2248)shelf.get(), new class_1792.class_1793().method_7892(SHELF_MOD_TAB)));
            SHELVES_ITEM.add((RegistrySupplier<class_1792>)shelf_item);
        }
    }

    public static void registerFloorShelves() {
        for (int i = 0; i < MATERIALS.size(); ++i) {
            class_2960 location = new class_2960(MODID, "floor_shelf_" + MATERIALS.get(i));
            RegistrySupplier floor_shelf = blocks.register(location, () -> new FloorShelf(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(0.5f, 3.0f).method_9626(class_2498.field_11547)));
            FLOOR_SHELVES_BLOCK.add((RegistrySupplier<class_2248>)floor_shelf);
            class_2960 itemLocation = new class_2960(MODID, "floor_shelf_item_" + MATERIALS.get(i));
            RegistrySupplier floor_shelf_item = items.register(itemLocation, () -> new class_1747((class_2248)floor_shelf.get(), new class_1792.class_1793().method_7892(SHELF_MOD_TAB)));
            FLOOR_SHELVES_ITEM.add((RegistrySupplier<class_1792>)floor_shelf_item);
        }
    }

    public static void generateBlockItemModels(List<RegistrySupplier<class_1792>> items, List<RegistrySupplier<class_2248>> blocks) {
        Path outputPath = Paths.get("resources/assets/shelfmod/models/item", new String[0]);
        try {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < blocks.size(); ++i) {
            String filename = ((class_1792)items.get(i).get()).method_7854().toString();
            Path file = outputPath.resolve(filename + ".json");
            JsonObject parent = new JsonObject();
            parent.addProperty("parent", "shelfmod:block/" + ((class_2248)blocks.get(i).get()).toString());
            String string = "resources/assets/shelfmod/models/item/" + filename + ".json";
        }
    }

    public static void initializeServer() {
        ICON = items.register(new class_2960(MODID, "icon"), () -> new class_1792(new class_1792.class_1793()));
        SHELF_MOD_TAB = CreativeTabRegistry.create((class_2960)new class_2960(MODID, "shelf_mod_tab"), () -> ((class_1792)ICON.get()).method_8389().method_7854());
        ShelfModCommon.registerShelves();
        ShelfModCommon.registerFloorShelves();
        SHELF_BLOCK_ENTITY = blockEntities.register(new class_2960(MODID, "shelf_block_entity"), () -> class_2591.class_2592.method_20528(ShelfBlockEntity::new, (class_2248[])((class_2248[])SHELVES_BLOCK.stream().map(Supplier::get).toArray(class_2248[]::new))).method_11034(null));
        FLOOR_SHELF_BLOCK_ENTITY = blockEntities.register(new class_2960(MODID, "floor_shelf_block_entity"), () -> class_2591.class_2592.method_20528(FloorShelfBlockEntity::new, (class_2248[])((class_2248[])FLOOR_SHELVES_BLOCK.stream().map(Supplier::get).toArray(class_2248[]::new))).method_11034(null));
        SHELVES_JSON = new ArrayList<JsonObject>();
        for (String material : MATERIALS) {
            SHELVES_JSON.add(ShelfModCommon.createShelfRecipe(material));
            SHELVES_JSON.add(ShelfModCommon.createFloorShelfRecipe(material));
        }
    }

    static {
        SHELVES_BLOCK = new ArrayList<RegistrySupplier<class_2248>>();
        SHELVES_ITEM = new ArrayList<RegistrySupplier<class_1792>>();
        FLOOR_SHELVES_BLOCK = new ArrayList<RegistrySupplier<class_2248>>();
        FLOOR_SHELVES_ITEM = new ArrayList<RegistrySupplier<class_1792>>();
        MATERIALS = List.of("oak", "acacia", "birch", "dark_oak", "spruce", "jungle", "warped", "crimson");
    }
}

