/*
 * Decompiled with CFR 0.152.
 */
package com.akciater;

import com.akciater.blocks.FloorShelf;
import com.akciater.blocks.FloorShelfBlockEntity;
import com.akciater.blocks.Shelf;
import com.akciater.blocks.ShelfBlockEntity;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public final class ShelfModCommon {
    public static final String MODID = "shelfmod";
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MODID));
    public static final Registrar<Block> blocks = MANAGER.get().get(Registries.f_256747_);
    public static final Registrar<Item> items = MANAGER.get().get(Registries.f_256913_);
    public static final Registrar<BlockEntityType<?>> blockEntities = MANAGER.get().get(Registries.f_256922_);
    public static RegistrySupplier<Item> ICON;
    public static RegistrySupplier<BlockEntityType<ShelfBlockEntity>> SHELF_BLOCK_ENTITY;
    public static RegistrySupplier<BlockEntityType<FloorShelfBlockEntity>> FLOOR_SHELF_BLOCK_ENTITY;
    public static CreativeTabRegistry.TabSupplier SHELF_MOD_TAB;
    public static List<RegistrySupplier<Block>> SHELVES_BLOCK;
    public static List<RegistrySupplier<Item>> SHELVES_ITEM;
    public static List<RegistrySupplier<Block>> FLOOR_SHELVES_BLOCK;
    public static List<RegistrySupplier<Item>> FLOOR_SHELVES_ITEM;
    public static List<JsonObject> SHELVES_JSON;
    public static List<String> MATERIALS;

    public static boolean isShelf(Item item) {
        for (RegistrySupplier<Item> shelf : SHELVES_ITEM) {
            if (shelf.get() != item) continue;
            return true;
        }
        for (RegistrySupplier<Item> shelf : FLOOR_SHELVES_ITEM) {
            if (shelf.get() != item) continue;
            return true;
        }
        return false;
    }

    public static JsonObject createShapedRecipeJson(ArrayList<Character> keys, ArrayList<ResourceLocation> items, ArrayList<String> type, ArrayList<String> pattern, ResourceLocation output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        json.addProperty("category", "misc");
        JsonArray jsonArray = new JsonArray();
        for (String line : pattern) {
            jsonArray.add(line);
        }
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(type.get(i), items.get(i).toString());
            keyList.add(keys.get(i).toString(), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("id", output.toString());
        result.addProperty("count", (Number)1);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createShelfRecipe(String material) {
        ResourceLocation shelf = new ResourceLocation(MODID, "shelf_item_" + material);
        return ShelfModCommon.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('_')}), Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation(material + "_fence"), new ResourceLocation(material + "_slab")}), Lists.newArrayList((Object[])new String[]{"item", "item"}), Lists.newArrayList((Object[])new String[]{"___", "# #", "___"}), shelf);
    }

    public static JsonObject createFloorShelfRecipe(String material) {
        ResourceLocation shelf = new ResourceLocation(MODID, "floor_shelf_item_" + material);
        return ShelfModCommon.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('@')}), Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation(material + "_fence"), new ResourceLocation(material + "_planks")}), Lists.newArrayList((Object[])new String[]{"item", "item"}), Lists.newArrayList((Object[])new String[]{"@#@", "#@#", "@#@"}), shelf);
    }

    public static void registerShelves() {
        for (int i = 0; i < MATERIALS.size(); ++i) {
            ResourceLocation location = new ResourceLocation(MODID, "shelf_" + MATERIALS.get(i));
            RegistrySupplier shelf = blocks.register(location, () -> new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
            SHELVES_BLOCK.add((RegistrySupplier<Block>)shelf);
            ResourceLocation itemLocation = new ResourceLocation(MODID, "shelf_item_" + MATERIALS.get(i));
            RegistrySupplier shelf_item = items.register(itemLocation, () -> new BlockItem((Block)shelf.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
            SHELVES_ITEM.add((RegistrySupplier<Item>)shelf_item);
        }
    }

    public static void registerFloorShelves() {
        for (int i = 0; i < MATERIALS.size(); ++i) {
            ResourceLocation location = new ResourceLocation(MODID, "floor_shelf_" + MATERIALS.get(i));
            RegistrySupplier floor_shelf = blocks.register(location, () -> new FloorShelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
            FLOOR_SHELVES_BLOCK.add((RegistrySupplier<Block>)floor_shelf);
            ResourceLocation itemLocation = new ResourceLocation(MODID, "floor_shelf_item_" + MATERIALS.get(i));
            RegistrySupplier floor_shelf_item = items.register(itemLocation, () -> new BlockItem((Block)floor_shelf.get(), new Item.Properties().arch$tab(SHELF_MOD_TAB)));
            FLOOR_SHELVES_ITEM.add((RegistrySupplier<Item>)floor_shelf_item);
        }
    }

    public static void generateBlockItemModels(List<RegistrySupplier<Item>> items, List<RegistrySupplier<Block>> blocks) {
        Path outputPath = Paths.get("resources/assets/shelfmod/models/item", new String[0]);
        try {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < blocks.size(); ++i) {
            String filename = ((Item)items.get(i).get()).arch$registryName().m_135815_();
            Path file = outputPath.resolve(filename + ".json");
            JsonObject parent = new JsonObject();
            parent.addProperty("parent", "shelfmod:block/" + ((Block)blocks.get(i).get()).arch$registryName().m_135815_());
            String string = "resources/assets/shelfmod/models/item/" + filename + ".json";
        }
    }

    public static void initializeServer() {
        ICON = items.register(new ResourceLocation(MODID, "icon"), () -> new Item(new Item.Properties()));
        SHELF_MOD_TAB = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation(MODID, "shelf_mod_tab"), () -> ((Item)ICON.get()).m_5456_().m_7968_());
        ShelfModCommon.registerShelves();
        ShelfModCommon.registerFloorShelves();
        SHELF_BLOCK_ENTITY = blockEntities.register(new ResourceLocation(MODID, "shelf_block_entity"), () -> BlockEntityType.Builder.m_155273_(ShelfBlockEntity::new, (Block[])((Block[])SHELVES_BLOCK.stream().map(Supplier::get).toArray(Block[]::new))).m_58966_(null));
        FLOOR_SHELF_BLOCK_ENTITY = blockEntities.register(new ResourceLocation(MODID, "floor_shelf_block_entity"), () -> BlockEntityType.Builder.m_155273_(FloorShelfBlockEntity::new, (Block[])((Block[])FLOOR_SHELVES_BLOCK.stream().map(Supplier::get).toArray(Block[]::new))).m_58966_(null));
        SHELVES_JSON = new ArrayList<JsonObject>();
        for (String material : MATERIALS) {
            SHELVES_JSON.add(ShelfModCommon.createShelfRecipe(material));
            SHELVES_JSON.add(ShelfModCommon.createFloorShelfRecipe(material));
        }
    }

    static {
        SHELVES_BLOCK = new ArrayList<RegistrySupplier<Block>>();
        SHELVES_ITEM = new ArrayList<RegistrySupplier<Item>>();
        FLOOR_SHELVES_BLOCK = new ArrayList<RegistrySupplier<Block>>();
        FLOOR_SHELVES_ITEM = new ArrayList<RegistrySupplier<Item>>();
        MATERIALS = List.of("oak", "acacia", "birch", "dark_oak", "spruce", "jungle", "mangrove", "bamboo", "warped", "cherry", "crimson");
    }
}

