/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.blocks;

import com.akciater.ShelfModCommon;
import com.akciater.blocks.ShelfBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class Shelf
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<Shelf> CODEC = Shelf.simpleCodec(Shelf::new);
    public static BooleanProperty WATERLOGGED = BooleanProperty.create((String)"waterlogged");
    public static DirectionProperty FACING = DirectionProperty.create((String)"facing");

    public Shelf(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ShelfBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ShelfBlockEntity entity = (ShelfBlockEntity)level.getChunk(pos).getBlockEntity(pos);
        if (entity != null) {
            ItemStack stack = player.getMainHandItem();
            if (ShelfModCommon.isShelf(stack.getItem())) {
                return InteractionResult.FAIL;
            }
            int slot = Shelf.getSlot(hit, (Direction)state.getValue((Property)FACING));
            if (!stack.isEmpty() && ((ItemStack)entity.inv.get(slot)).isEmpty()) {
                entity.inv.set(slot, (Object)stack);
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            } else if (stack.isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)entity.inv.get(slot));
                entity.inv.set(slot, (Object)ItemStack.EMPTY);
            } else if (!stack.isEmpty() && !((ItemStack)entity.inv.get(slot)).isEmpty()) {
                ItemStack temp = stack.copy();
                player.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)entity.inv.get(slot));
                entity.inv.set(slot, (Object)temp);
            }
            entity.markDirty();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static int getSlot(BlockHitResult hit, Direction dir) {
        Vec3 pos = hit.getLocation();
        BlockPos blockPos = hit.getBlockPos();
        double x = Math.abs(pos.x - (double)blockPos.getX());
        double y = Math.abs(pos.y - (double)blockPos.getY());
        double z = Math.abs(pos.z - (double)blockPos.getZ());
        int slot = 0;
        if (dir == Direction.EAST && z > 0.5) {
            ++slot;
        }
        if (dir == Direction.WEST && z < 0.5) {
            ++slot;
        }
        if (dir == Direction.NORTH && x > 0.5) {
            ++slot;
        }
        if (dir == Direction.SOUTH && x < 0.5) {
            ++slot;
        }
        if (y > 0.5) {
            slot += 2;
        }
        return slot;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            ShelfBlockEntity entity = (ShelfBlockEntity)level.getChunk(pos).getBlockEntity(pos);
            if (entity != null && !entity.isEmpty()) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack itemStack = (ItemStack)entity.inv.get(i);
                    if (itemStack.isEmpty()) continue;
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack);
                }
                entity.inv.clear();
                entity.setRemoved();
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)state.getBlock().asItem().getDefaultInstance());
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        switch (dir) {
            case NORTH: {
                return Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
            }
            case SOUTH: {
                return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
            }
            case EAST: {
                return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0);
            }
            case WEST: {
                return Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
        }
        return Shapes.block();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(blockPos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED}).add(new Property[]{FACING});
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }
}

