/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.client.ber;

import com.akciater.blocks.FloorShelf;
import com.akciater.blocks.FloorShelfBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class FloorShelfBER
implements BlockEntityRenderer<FloorShelfBlockEntity> {
    public List<Vec3> positions = new ArrayList<Vec3>(List.of(new Vec3(0.265625, (double)0.275f, 0.265625), new Vec3(0.734375, (double)0.275f, 0.265625), new Vec3(0.265625, (double)0.275f, 0.734375), new Vec3(0.734375, (double)0.275f, 0.734375)));

    public Quaternionf getRotation(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> Axis.YP.rotationDegrees(0.0f);
            case Direction.EAST -> Axis.YP.rotationDegrees(270.0f);
            case Direction.SOUTH -> Axis.YP.rotationDegrees(180.0f);
            case Direction.WEST -> Axis.YP.rotationDegrees(90.0f);
            default -> null;
        };
    }

    public FloorShelfBER(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FloorShelfBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level world = entity.getLevel();
        BlockState state = world.getBlockState(entity.getBlockPos());
        if (state.getBlock() == Blocks.AIR) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Quaternionf quaternionf = this.getRotation((Direction)state.getValue((Property)FloorShelf.FACING));
        float blockSize = 1.0f;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = (ItemStack)entity.inv.get(i);
            if (stack.isEmpty()) continue;
            Vec3 pos = this.positions.get(i);
            poseStack.pushPose();
            poseStack.translate(pos.x, pos.y - 0.40625 * (double)(1.0f - blockSize) / 2.0, pos.z);
            boolean fullBlock = stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock().defaultBlockState().isCollisionShapeFullBlock((BlockGetter)entity.getLevel(), entity.getBlockPos());
            float scale = fullBlock ? 0.8125f : 0.40625f;
            poseStack.scale(scale * blockSize, scale * blockSize, scale * blockSize);
            poseStack.mulPose(quaternionf);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, entity.getLevel(), 1);
            poseStack.popPose();
        }
    }
}

