/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.blocks;

import com.akciater.ShelfModCommon;
import com.akciater.blocks.FloorShelfBlockEntity;
import com.akciater.blocks.Shelf;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FloorShelf
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<Shelf> CODEC = FloorShelf.simpleCodec(Shelf::new);
    public static BooleanProperty WATERLOGGED = BooleanProperty.create((String)"waterlogged");
    public static EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public FloorShelf(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FloorShelfBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FloorShelfBlockEntity(pos, state);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        FloorShelfBlockEntity blockEntity = (FloorShelfBlockEntity)level.getChunk(pos).getBlockEntity(pos);
        if (blockEntity != null) {
            ItemStack stack = player.getMainHandItem();
            if (ShelfModCommon.isShelf(stack.getItem())) {
                return InteractionResult.FAIL;
            }
            int slot = FloorShelf.getSlot(hit, (Direction)state.getValue(FACING));
            if (!stack.isEmpty() && ((ItemStack)blockEntity.inv.get(slot)).isEmpty()) {
                blockEntity.inv.set(slot, (Object)stack);
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            } else if (stack.isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)blockEntity.inv.get(slot));
                blockEntity.inv.set(slot, (Object)ItemStack.EMPTY);
            }
            blockEntity.markDirty();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static int getSlot(BlockHitResult hit, Direction dir) {
        Vec3 pos = hit.getLocation();
        BlockPos blockPos = hit.getBlockPos();
        double x = Math.abs(pos.x - (double)blockPos.getX());
        double z = Math.abs(pos.z - (double)blockPos.getZ());
        int slot = 0;
        if (x > 0.5 && z > 0.5) {
            slot = 3;
        } else if (z > 0.5) {
            slot += 2;
        } else if (x > 0.5) {
            ++slot;
        }
        return slot;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue(FACING);
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                return Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.3125, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0, (double)0.3125, (double)0.3125, (double)0.0625, (double)0.5, (double)0.6875), Shapes.box((double)0.9375, (double)0.3125, (double)0.3125, (double)1.0, (double)0.5, (double)0.6875)});
            }
            case EAST: 
            case WEST: {
                return Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.3125, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.5, (double)0.0625), Shapes.box((double)0.3125, (double)0.3125, (double)0.9375, (double)0.6875, (double)0.5, (double)1.0)});
            }
        }
        return Shapes.block();
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            FloorShelfBlockEntity entity = (FloorShelfBlockEntity)level.getBlockEntity(pos);
            if (entity != null && !entity.isEmpty()) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack itemStack = (ItemStack)entity.inv.get(i);
                    if (itemStack.isEmpty()) continue;
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack);
                }
                entity.inv.clear();
                entity.setRemoved();
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)state.getBlock().asItem().getDefaultInstance());
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(blockPos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED}).add(new Property[]{FACING});
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction direction, BlockPos arg6, BlockState arg7, RandomSource arg8) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return super.updateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, arg6, arg7, arg8);
    }
}

