/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.blocks;

import com.akciater.ShelfModCommon;
import com.akciater.blocks.FloorShelfBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FloorShelf
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static BooleanProperty WATERLOGGED = BooleanProperty.m_61465_((String)"waterlogged");
    public static DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");

    public FloorShelf(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FloorShelfBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FloorShelfBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        FloorShelfBlockEntity blockEntity = (FloorShelfBlockEntity)level.m_46865_(pos).m_7702_(pos);
        if (blockEntity != null) {
            ItemStack stack = player.m_21205_();
            if (ShelfModCommon.isShelf(stack.m_41720_())) {
                return InteractionResult.FAIL;
            }
            int slot = FloorShelf.getSlot(hit, (Direction)state.m_61143_((Property)FACING));
            if (!stack.m_41619_() && ((ItemStack)blockEntity.inv.get(slot)).m_41619_()) {
                blockEntity.inv.set(slot, (Object)stack);
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            } else if (stack.m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)blockEntity.inv.get(slot));
                blockEntity.inv.set(slot, (Object)ItemStack.f_41583_);
            }
            blockEntity.markDirty();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static int getSlot(BlockHitResult hit, Direction dir) {
        Vec3 pos = hit.m_82450_();
        BlockPos blockPos = hit.m_82425_();
        double x = Math.abs(pos.f_82479_ - (double)blockPos.m_123341_());
        double z = Math.abs(pos.f_82481_ - (double)blockPos.m_123343_());
        int slot = 0;
        if (x > 0.5 && z > 0.5) {
            slot = 3;
        } else if (z > 0.5) {
            slot += 2;
        } else if (x > 0.5) {
            ++slot;
        }
        return slot;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                return Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.3125, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.0, (double)0.3125, (double)0.3125, (double)0.0625, (double)0.5, (double)0.6875), Shapes.m_83048_((double)0.9375, (double)0.3125, (double)0.3125, (double)1.0, (double)0.5, (double)0.6875)});
            }
            case EAST: 
            case WEST: {
                return Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.3125, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.5, (double)0.0625), Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.9375, (double)0.6875, (double)0.5, (double)1.0)});
            }
        }
        return Shapes.m_83144_();
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            FloorShelfBlockEntity entity = (FloorShelfBlockEntity)level.m_46865_(pos).m_7702_(pos);
            if (entity != null && !entity.isEmpty()) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack itemStack = (ItemStack)entity.inv.get(i);
                    if (itemStack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
                }
                entity.inv.clear();
                entity.m_7651_();
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, movedByPiston);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{FACING});
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }
}

