/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.mixin;

import com.akciater.ShelfModCommon;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Final
    @Shadow
    private HolderLookup.Provider registries;
    private Boolean loaded = false;
    private static final Logger shelfmod$LOGGER = Logger.getLogger("ShelfMod");

    @Shadow
    protected static RecipeHolder<?> fromJson(ResourceKey<Recipe<?>> recipe, JsonObject json, HolderLookup.Provider registries) {
        return null;
    }

    @Shadow
    protected void apply(RecipeMap object, ResourceManager resourceManager, ProfilerFiller profiler) {
        throw new UnsupportedOperationException("Shadow method");
    }

    @Inject(method={"apply(Lnet/minecraft/world/item/crafting/RecipeMap;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="TAIL")})
    public void interceptApply(RecipeMap object, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        if (!this.loaded.booleanValue()) {
            HolderLookup.Provider registries1;
            this.loaded = true;
            try {
                registries1 = this.registries;
            }
            catch (Throwable t) {
                registries1 = null;
            }
            if (registries1 == null) {
                return;
            }
            ArrayList allRecipes = new ArrayList(object.values());
            for (int i = 0; i < ShelfModCommon.MATERIALS.size(); ++i) {
                ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"shelfmod", (String)("shelf_item_" + ShelfModCommon.MATERIALS.get(i)));
                ResourceLocation floorShelfId = ResourceLocation.fromNamespaceAndPath((String)"shelfmod", (String)("floor_shelf_item_" + ShelfModCommon.MATERIALS.get(i)));
                JsonObject shelfJSON = ShelfModCommon.SHELVES_JSON.get(i * 2);
                JsonObject floorShelfJSON = ShelfModCommon.SHELVES_JSON.get(i * 2 + 1);
                ResourceKey shelfKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceLocation);
                ResourceKey floorShelfKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)floorShelfId);
                RecipeHolder<?> shelfRecipe = RecipeManagerMixin.fromJson(shelfKey, shelfJSON, this.registries);
                RecipeHolder<?> floorShelfRecipe = RecipeManagerMixin.fromJson(floorShelfKey, floorShelfJSON, this.registries);
                allRecipes.add(shelfRecipe);
                allRecipes.add(floorShelfRecipe);
            }
            for (RecipeHolder recipeHolder : allRecipes) {
                ResourceKey key = recipeHolder.id();
                if (key == null || !key.location().getNamespace().equals("shelfmod")) continue;
                System.out.println("Loaded mod recipe: " + String.valueOf(key.location()));
            }
            RecipeMap newMap = RecipeMap.create(allRecipes);
            this.apply(newMap, resourceManager, profiler);
        }
        shelfmod$LOGGER.info("Loaded shelfmod recipes");
    }
}

