/*
 * Decompiled with CFR 0.152.
 */
package com.akciater.mixin;

import com.akciater.ShelfModCommon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    private static final Logger shelfmod$LOGGER = Logger.getLogger("ShelfMod");

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    public void interceptApply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        for (int i = 0; i < ShelfModCommon.MATERIALS.size(); ++i) {
            ResourceLocation shelfId = new ResourceLocation("shelfmod", "shelf_item_" + ShelfModCommon.MATERIALS.get(i));
            ResourceLocation floorShelfId = new ResourceLocation("shelfmod", "floor_shelf_item_" + ShelfModCommon.MATERIALS.get(i));
            JsonObject shelfJSON = ShelfModCommon.SHELVES_JSON.get(i * 2);
            JsonObject floorShelfJSON = ShelfModCommon.SHELVES_JSON.get(i * 2 + 1);
            object.put(shelfId, (JsonElement)shelfJSON);
            object.put(floorShelfId, (JsonElement)floorShelfJSON);
        }
        shelfmod$LOGGER.info("Loaded shelfmod recipes");
    }
}

