/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ManaStackType;
import com.wintercogs.beyonddimensions.Api.Util.CapCtx;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.UnknownNullability;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.spark.SparkAttachable;

public class ManaStackTypedHandler
implements ManaCollector,
ManaPool,
SparkAttachable {
    private StackTypedHandler storageHandler;
    private Level level;
    private BlockPos pos;

    public ManaStackTypedHandler(StackTypedHandler storageHandler, CapCtx ctx) {
        this.storageHandler = storageHandler;
        this.level = ctx.level();
        this.pos = ctx.pos();
    }

    public @UnknownNullability Level getManaReceiverLevel() {
        return this.level;
    }

    public BlockPos getManaReceiverPos() {
        return this.pos;
    }

    public int getCurrentMana() {
        return this.storageHandler.getTypeIdIndexList(ManaStackType.ID).map(list -> list.stream().filter(idx -> idx >= 0).map(this.storageHandler::getStackBySlot).filter(ManaStackType.class::isInstance).map(ManaStackType.class::cast).mapToLong(LongStackType::getStackAmount).sum()).map(BDMath::clampLongToInt).orElse(0);
    }

    public boolean isFull() {
        for (IStackType stack : this.storageHandler.getStorage()) {
            if (stack.isEmpty()) {
                return false;
            }
            if (!(stack instanceof ManaStackType) || stack.getStackAmount() >= stack.getVanillaMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public void receiveMana(int mana) {
        if (mana > 0) {
            this.storageHandler.insert(new ManaStackType(mana), false);
        } else {
            this.storageHandler.extract(new ManaStackType(-mana), false);
        }
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public void onClientDisplayTick() {
    }

    public float getManaYieldMultiplier(ManaBurst burst) {
        return 1.0f;
    }

    public boolean isOutputtingPower() {
        return true;
    }

    public int getMaxMana() {
        long maxMana = 0L;
        ManaStackType stackType = new ManaStackType();
        for (IStackType stack : this.storageHandler.getStorage()) {
            if (stack.isEmpty()) {
                maxMana += stackType.getVanillaMaxStackSize();
            }
            if (!(stack instanceof ManaStackType) || stack.getStackAmount() >= stack.getVanillaMaxStackSize()) continue;
            maxMana += stack.getVanillaMaxStackSize() - stack.getStackAmount();
        }
        return BDMath.clampLongToInt(maxMana);
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        return this.getMaxMana() - this.getCurrentMana();
    }

    public boolean areIncomingTransfersDone() {
        return this.isFull();
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public @UnknownNullability Level getLevel() {
        return this.level;
    }
}

