/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.WardenSoulType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class WardenSoulStackType
extends LongStackType<WardenSoulType> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/warden_soul");
    public static final WardenSoulStackType EMPTY = new WardenSoulStackType();
    public static final MapCodec<WardenSoulStackType> TYPE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WardenSoulType.CODEC.fieldOf("internal_stack").forGetter(LongStackType::getStack)).apply((Applicative)instance, WardenSoulStackType::new));
    public static final Codec<WardenSoulStackType> CODEC = TYPE_CODEC.codec();
    private static long lastCheckedForParticle = 0L;
    private static List<GuiParticle> particleList = new ArrayList<GuiParticle>();

    public WardenSoulStackType() {
        this.stack = new WardenSoulType(0L);
    }

    public WardenSoulStackType(WardenSoulType stack) {
        this.stack = stack;
    }

    public WardenSoulStackType(long stackSize) {
        this.stack = new WardenSoulType(stackSize);
    }

    @Override
    public ResourceLocation getTypeID() {
        return ID;
    }

    @Override
    public String getModId() {
        return "industrialforegoingsouls";
    }

    @Override
    public MapCodec<? extends IStackType<WardenSoulType>> codec() {
        return TYPE_CODEC;
    }

    @Override
    public IStackType<WardenSoulType> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof WardenSoulType) {
            return new WardenSoulStackType(amount);
        }
        return null;
    }

    @Override
    public IStackType<WardenSoulType> getEmpty() {
        return new WardenSoulStackType(0L);
    }

    @Override
    public Object getSource() {
        return new WardenSoulType(0L);
    }

    @Override
    public WardenSoulType getEmptyStack() {
        return new WardenSoulType(0L);
    }

    @Override
    public IStackType<WardenSoulType> copy() {
        WardenSoulStackType copy = new WardenSoulStackType(((WardenSoulType)this.stack).getStackCount());
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<WardenSoulType> copyWithCount(long count) {
        WardenSoulStackType copy = new WardenSoulStackType(count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<WardenSoulType> split(long amount) {
        if (amount <= 0L) {
            return new WardenSoulStackType();
        }
        long splitAmount = Math.min(amount, ((WardenSoulType)this.stack).getStackCount());
        ((WardenSoulType)this.stack).shrink(splitAmount);
        return new WardenSoulStackType(splitAmount);
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        return false;
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 64000L;
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        buf.writeVarLong(((WardenSoulType)this.stack).getStackCount());
    }

    @Override
    public IStackType<WardenSoulType> deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        long count = buf.readVarLong();
        return new WardenSoulStackType(count);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Type", ID.toString());
        tag.putLong("Amount", this.getStackAmount());
        return tag;
    }

    @Override
    public IStackType<WardenSoulType> deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        return new WardenSoulStackType(nbt.getLong("Amount"));
    }

    @Override
    public void render(GuiGraphics gui, int x, int y) {
        int ageTick;
        if (((WardenSoulType)this.stack).isEmpty()) {
            return;
        }
        gui.pose().pushPose();
        ResourceLocation warden_rl = ResourceLocation.withDefaultNamespace((String)"textures/entity/warden/warden.png");
        ResourceLocation warden_hear = ResourceLocation.withDefaultNamespace((String)"textures/entity/warden/warden_heart.png");
        gui.blit(warden_rl, x, y, 12.0f, 14.0f, 16, 16, 128, 128);
        gui.pose().pushPose();
        float heart_timing = 30.0f;
        heart_timing = 1.0f - (float)Minecraft.getInstance().level.getGameTime() % heart_timing / heart_timing;
        RenderSystem.setShaderColor((float)heart_timing, (float)heart_timing, (float)heart_timing, (float)heart_timing);
        gui.blit(warden_hear, x - 1, y - 1, 11.0f, 13.0f, 18, 18, 128, 128);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.pose().popPose();
        long rotation = Minecraft.getInstance().level.getGameTime() % 160L - 80L;
        gui.pose().pushPose();
        gui.pose().translate((float)x, (float)(y - 1), 100.0f);
        gui.pose().mulPose(Axis.YP.rotationDegrees((float)rotation));
        gui.blit(warden_rl, 0, 0, 91.0f, 13.0f, 17, 18, 128, 128);
        gui.pose().popPose();
        gui.pose().pushPose();
        gui.pose().translate((float)(x + 16), (float)(y + 17), 100.0f);
        gui.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        gui.pose().mulPose(Axis.YP.rotationDegrees((float)rotation));
        gui.blit(warden_rl, 0, 0, 91.0f, 13.0f, 17, 18, 128, 128);
        gui.pose().popPose();
        gui.pose().scale(0.75f, 0.75f, 0.75f);
        double fullAmount = 0.05;
        int xSize = 8;
        int ySize = 6;
        long currentTime = Minecraft.getInstance().level.getGameTime();
        if (lastCheckedForParticle != currentTime) {
            if (Minecraft.getInstance().level.random.nextDouble() <= fullAmount) {
                particleList.add(new GuiParticle(this, Minecraft.getInstance().level.random.nextInt(xSize), ySize - Minecraft.getInstance().level.random.nextInt(3), currentTime));
            }
            lastCheckedForParticle = currentTime;
        }
        if (currentTime % (long)(ageTick = 3) == 0L) {
            particleList.removeIf(guiParticlex -> (currentTime - guiParticlex.age) / (long)ageTick > 10L);
        }
        gui.pose().translate(0.0f, 0.0f, 200.0f);
        for (GuiParticle guiParticle : particleList.reversed()) {
            double particleAge = (double)(currentTime - guiParticle.age) / (double)ageTick;
            double extraY = (double)(ySize - 32) / 20.0 * particleAge;
            gui.blit(ResourceLocation.withDefaultNamespace((String)("textures/particle/sculk_soul_" + Math.max(0, Math.min(10, (int)particleAge)) + ".png")), (int)((float)(x + guiParticle.x) * 1.3333334f), (int)((float)((int)((double)(y + guiParticle.y) + extraY)) * 1.3333334f), 0.0f, 0.0f, 16, 16, 16, 16);
        }
        gui.pose().popPose();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((WardenSoulType)this.stack).isEmpty()) {
            gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.popPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private class GuiParticle {
        private int x;
        private int y;
        private long age;

        public GuiParticle(WardenSoulStackType wardenSoulStackType, int x, int y, long age) {
            this.x = x;
            this.y = y;
            this.age = age;
        }
    }
}

