/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidHandlerWrapper
implements IStackHandlerWrapper<FluidStack> {
    private final IFluidHandler fluidHandler;

    public FluidHandlerWrapper(Object fluidHandler) {
        this.fluidHandler = (IFluidHandler)fluidHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return FluidStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.fluidHandler.getTanks();
    }

    @Override
    public FluidStack getStackInSlot(int slot) {
        return this.fluidHandler.getFluidInTank(slot);
    }

    @Override
    public long getCapacity(int slot) {
        return this.fluidHandler.getTankCapacity(slot);
    }

    @Override
    public boolean isStackValid(int slot, FluidStack stack) {
        return this.fluidHandler.isFluidValid(slot, stack);
    }

    @Override
    public long insert(int slot, FluidStack stack, boolean sim) {
        return this.insert(stack, sim);
    }

    @Override
    public long insert(FluidStack stack, boolean sim) {
        int currentNum = stack.getAmount();
        int insert = sim ? this.fluidHandler.fill(stack, IFluidHandler.FluidAction.SIMULATE) : this.fluidHandler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        return stack.copyWithAmount(currentNum - insert).getAmount();
    }

    @Override
    public long extract(int slot, long amount, boolean sim) {
        for (int i = 0; i < this.getSlots(); ++i) {
            FluidStack stack = this.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (sim) {
                return this.fluidHandler.drain(stack.copyWithAmount((int)Math.min(amount, Integer.MAX_VALUE)), IFluidHandler.FluidAction.SIMULATE).getAmount();
            }
            return this.fluidHandler.drain(stack.copyWithAmount((int)Math.min(amount, Integer.MAX_VALUE)), IFluidHandler.FluidAction.EXECUTE).getAmount();
        }
        return 0L;
    }

    @Override
    public long extract(FluidStack stack, boolean sim) {
        if (sim) {
            return this.fluidHandler.drain(stack, IFluidHandler.FluidAction.SIMULATE).getAmount();
        }
        return this.fluidHandler.drain(stack, IFluidHandler.FluidAction.EXECUTE).getAmount();
    }
}

