/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyUnifiedStorageHandler
implements IEnergyStorage {
    private UnifiedStorage storage;

    public EnergyUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int receiveEnergy(int count, boolean simulate) {
        return (int)((long)count - this.storage.insert(new EnergyStackType(count), simulate).getStackAmount());
    }

    public int extractEnergy(int count, boolean simulate) {
        return (int)this.storage.extract(new EnergyStackType(count), simulate).getStackAmount();
    }

    public int getEnergyStored() {
        return this.storage.getTypeIdIndexList(EnergyStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (EnergyStackType)this.storage.getStackBySlot((int)actualIndex)).map(energyStackType -> BDMath.clampLongToInt(energyStackType.getStackAmount())).orElse(0);
    }

    public int getMaxEnergyStored() {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

