/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ManaStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Api.Util.CapCtx;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.UnknownNullability;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.spark.SparkAttachable;

public class ManaUnifiedStorageHandler
implements ManaCollector,
ManaPool,
SparkAttachable {
    private UnifiedStorage storage;
    private Level level;
    private BlockPos pos;

    public ManaUnifiedStorageHandler(UnifiedStorage storage, CapCtx ctx) {
        this.storage = storage;
        this.level = ctx.level();
        this.pos = ctx.pos();
    }

    public UnifiedStorage getStorage() {
        return this.storage;
    }

    public @UnknownNullability Level getManaReceiverLevel() {
        return this.level;
    }

    public BlockPos getManaReceiverPos() {
        return this.pos;
    }

    public long getActualCurrentMana() {
        return this.storage.getTypeIdIndexList(ManaStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (ManaStackType)this.storage.getStackBySlot((int)actualIndex)).map(stack -> stack.getStackAmount()).orElse(0L);
    }

    public long getActualMaxMana() {
        return this.storage.getSlotCapacity(0);
    }

    public int getCurrentMana() {
        return this.storage.getTypeIdIndexList(ManaStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (ManaStackType)this.storage.getStackBySlot((int)actualIndex)).map(stack -> BDMath.clampLongToInt(stack.getStackAmount())).orElse(0);
    }

    public boolean isFull() {
        IStackType stack = this.storage.getStackByStack(new ManaStackType(0L));
        long currentMana = stack == null ? 0L : stack.getStackAmount();
        return currentMana >= this.storage.getSlotCapacity(0) || currentMana < this.storage.getSlotCapacity(0) && this.storage.isFullSlotsSize();
    }

    public void receiveMana(int mana) {
        if (mana > 0) {
            this.storage.insert(new ManaStackType(mana), false);
        } else {
            this.storage.extract(new ManaStackType(-mana), false);
        }
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public void onClientDisplayTick() {
    }

    public float getManaYieldMultiplier(ManaBurst burst) {
        return 1.0f;
    }

    public boolean isOutputtingPower() {
        return true;
    }

    public int getMaxMana() {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        return this.getMaxMana() - this.getCurrentMana();
    }

    public boolean areIncomingTransfersDone() {
        return this.isFull();
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public @UnknownNullability Level getLevel() {
        return this.level;
    }
}

