/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Fluid;

import com.wintercogs.beyonddimensions.Block.ModBlocks;
import com.wintercogs.beyonddimensions.Fluid.Custom.XpFluid;
import com.wintercogs.beyonddimensions.Item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="beyonddimensions", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ModFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"beyonddimensions");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"beyonddimensions");
    public static final List<FluidEntry> ALL = new ArrayList<FluidEntry>();
    public static final FluidEntry XP_FLUID = ModFluids.registerFluid("xp_fluid", FluidType.Properties.create().lightLevel(10).density(800).viscosity(1500), -1, 10, XpFluid.Source::new, XpFluid.Flowing::new);

    public static <S extends BaseFlowingFluid.Source, F extends BaseFlowingFluid.Flowing> FluidEntry registerFluid(String name, FluidType.Properties typeProps, int argbTint, int lightlevel, Function<BaseFlowingFluid.Properties, S> sourceCtor, Function<BaseFlowingFluid.Properties, F> flowingCtor) {
        DeferredHolder type = FLUID_TYPES.register(name, () -> new FluidType(typeProps));
        BaseFlowingFluid.Properties[] propsRef = new BaseFlowingFluid.Properties[1];
        DeferredHolder source = FLUIDS.register(name, () -> (BaseFlowingFluid.Source)sourceCtor.apply(propsRef[0]));
        DeferredHolder flowing = FLUIDS.register("flowing_" + name, () -> (BaseFlowingFluid.Flowing)flowingCtor.apply(propsRef[0]));
        DeferredBlock block = ModBlocks.BLOCKS.register(name, () -> new LiquidBlock((FlowingFluid)source.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).lightLevel(s -> lightlevel)));
        DeferredItem bucket = ModItems.ITEMS.register(name + "_bucket", () -> new BucketItem((Fluid)source.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        propsRef[0] = new BaseFlowingFluid.Properties((Supplier)type, (Supplier)source, (Supplier)flowing).bucket((Supplier)bucket).block((Supplier)block).slopeFindDistance(4).levelDecreasePerBlock(2);
        FluidEntry entry = new FluidEntry(name, (DeferredHolder<FluidType, FluidType>)type, (DeferredHolder<Fluid, ? extends BaseFlowingFluid.Source>)source, (DeferredHolder<Fluid, ? extends BaseFlowingFluid.Flowing>)flowing, (DeferredHolder<Block, LiquidBlock>)block, (DeferredHolder<Item, Item>)bucket, argbTint);
        ALL.add(entry);
        return entry;
    }

    public static FluidEntry registerSimpleFluid(String name, FluidType.Properties typeProps, int argbTint, int lightlevel) {
        return ModFluids.registerFluid(name, typeProps, argbTint, lightlevel, BaseFlowingFluid.Source::new, BaseFlowingFluid.Flowing::new);
    }

    public static void register(IEventBus modBus) {
        FLUID_TYPES.register(modBus);
        FLUIDS.register(modBus);
    }

    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        for (FluidEntry e : ALL) {
            final ResourceLocation still = ResourceLocation.tryBuild((String)"beyonddimensions", (String)("block/" + e.name() + "_still"));
            final ResourceLocation flow = ResourceLocation.tryBuild((String)"beyonddimensions", (String)("block/" + e.name() + "_flow"));
            final int tint = e.argbTint();
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return still;
                }

                public ResourceLocation getFlowingTexture() {
                    return flow;
                }

                public int getTintColor() {
                    return tint;
                }
            }, new FluidType[]{(FluidType)e.type().get()});
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent evt) {
        evt.enqueueWork(() -> {
            for (FluidEntry e : ALL) {
                ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)e.source().get()), (RenderType)RenderType.translucent());
                ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)e.flowing().get()), (RenderType)RenderType.translucent());
            }
        });
    }

    public record FluidEntry(String name, DeferredHolder<FluidType, FluidType> type, DeferredHolder<Fluid, ? extends BaseFlowingFluid.Source> source, DeferredHolder<Fluid, ? extends BaseFlowingFluid.Flowing> flowing, DeferredHolder<Block, LiquidBlock> block, DeferredHolder<Item, Item> bucket, int argbTint) {
    }
}

