/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.EMI.SlotHandler;

import appeng.api.stacks.GenericStack;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.Registry.StackTypeRegistry;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.Integration.AE.AEHelper;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Packet.SetSlotDirectlyPacket;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class SlotDragHandler
implements EmiDragDropHandler<Screen> {
    public void render(Screen screen, EmiIngredient dragged, GuiGraphics draw, int mouseX, int mouseY, float delta) {
        if (!(screen instanceof BDBaseGUI)) {
            return;
        }
        BDBaseGUI bdGUI = (BDBaseGUI)screen;
        for (Slot slot : bdGUI.getMenu().slots) {
            if (!(slot instanceof AbstractStackTypedSlot) || !slot.isFake()) continue;
            int slotLeft = bdGUI.getGuiLeft() + slot.x;
            int slotTop = bdGUI.getGuiTop() + slot.y;
            draw.fill(slotLeft, slotTop, slotLeft + 16, slotTop + 16, -2010989773);
        }
    }

    public boolean dropStack(Screen screen, EmiIngredient ingredient, int x, int y) {
        if (!(screen instanceof BDBaseGUI)) {
            return false;
        }
        BDBaseGUI bdGUI = (BDBaseGUI)screen;
        for (Slot slot : bdGUI.getMenu().slots) {
            int slotTop;
            int slotLeft;
            Rect2i slotRect;
            if (!(slot instanceof AbstractStackTypedSlot) || !slot.isFake() || !(slotRect = new Rect2i(slotLeft = bdGUI.getGuiLeft() + slot.x, slotTop = bdGUI.getGuiTop() + slot.y, 16, 16)).contains(x, y)) continue;
            Object stackKey = ((EmiStack)ingredient.getEmiStacks().get(0)).getKey();
            DataComponentPatch dataComponentPatch = ((EmiStack)ingredient.getEmiStacks().get(0)).getComponentChanges();
            IStackType<ItemStack> dragging = new ItemStackType();
            for (IStackType<?> type : StackTypeRegistry.getAllTypes()) {
                if (!type.getSourceClass().isAssignableFrom(stackKey.getClass())) continue;
                dragging = type.fromObject(stackKey, 1L, dataComponentPatch);
                break;
            }
            if (BeyondDimensions.AELoaded && dragging instanceof ItemStackType) {
                GenericStack genericContent;
                ItemStackType draggingItem = dragging;
                if (!dragging.isEmpty() && (genericContent = GenericStack.fromItemStack((ItemStack)draggingItem.getStack())) != null) {
                    dragging = AEHelper.fromAEKeyToIStack(genericContent.what(), 1L).orElse(new ItemStackType());
                }
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new SetSlotDirectlyPacket(slot.index, dragging), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }
}

