/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetInterfaceBlockEntity;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.FlagStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.OrderedStackTypedSlot;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NetInterfaceBaseMenu
extends BDBaseMenu {
    private static final int slotStartY = 25;
    private static final int invSlotStartY = 147;
    public final StackTypedHandler storage;
    public final StackTypedHandler flagStorage;
    public NetInterfaceBlockEntity be;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetInterfaceBaseMenu>> Net_Interface_Menu = MENU_TYPES.register("net_interface_menu", () -> IMenuTypeExtension.create(NetInterfaceBaseMenu::new));

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, new StackTypedHandler(27), new StackTypedHandler(27), (NetInterfaceBlockEntity)playerInventory.player.level().getBlockEntity(data.readBlockPos()));
    }

    public NetInterfaceBaseMenu(int id, Inventory playerInventory, StackTypedHandler storage, StackTypedHandler flagStorage, NetInterfaceBlockEntity be) {
        super(Net_Interface_Menu.get(), id, playerInventory);
        this.storage = storage;
        this.flagStorage = flagStorage;
        this.be = be;
        this.addPlayerInv(playerInventory);
        this.addStorageSlots();
        this.addFlagSlots();
    }

    private void addStorageSlots() {
        this.vanillaQuickMoveStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new OrderedStackTypedSlot(this, this.storage, row * 9 + col, this.inventoryStartIndex, this.inventoryEndIndex, 8 + col * 18, 43 + row * 36));
            }
        }
        this.vanillaQuickMoveEndIndex = this.slots.size();
    }

    private void addFlagSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                FlagStackTypedSlot flagSlot = new FlagStackTypedSlot(this, this.flagStorage, row * 9 + col, 8 + col * 18, 25 + row * 36);
                this.addSlot(flagSlot);
            }
        }
    }

    private void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 147 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 205));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    @Override
    protected boolean shouldSendQuickData() {
        return false;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.putString("popMode", this.be.popMode.name());
        tag.putString("controlMode", this.be.controlMode.name());
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        this.be.popMode = PopMode.valueOf(tag.getString("popMode"));
        this.be.controlMode = RedStoneControlMode.valueOf(tag.getString("controlMode"));
        if (!this.player.level().isClientSide()) {
            this.player.level().blockEntityChanged(this.be.getBlockPos());
            this.player.level().sendBlockUpdated(this.be.getBlockPos(), this.be.getBlockState(), this.be.getBlockState(), 2);
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return this.be != null && !this.be.isRemoved();
    }
}

