/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.SlotGroupSync;
import com.wintercogs.beyonddimensions.Packet.DisorderedSlotGroupSyncPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;

public class DisorderedSlotGroupSync
implements SlotGroupSync {
    public final int groupId;
    private final BDBaseMenu menu;
    private final IStackTypedHandler storage;
    private final List<IStackType> lastStorage = new ArrayList<IStackType>();

    public DisorderedSlotGroupSync(BDBaseMenu menu, int id, IStackTypedHandler storage) {
        this.menu = menu;
        this.groupId = id;
        this.storage = storage;
    }

    @Override
    public int getGroupId() {
        return this.groupId;
    }

    @Override
    public void updateChange() {
        ArrayList changedItem = new ArrayList();
        ArrayList<Long> changedCount = new ArrayList<Long>();
        HashMap<IStackType, Long> lastMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : this.lastStorage) {
            lastMap.put(iStackType, lastMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        HashMap<IStackType, Long> nowMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : this.storage.getStorage()) {
            nowMap.put(iStackType, nowMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        this.refreshLast();
        HashSet hashSet = new HashSet();
        hashSet.addAll(lastMap.keySet());
        hashSet.addAll(nowMap.keySet());
        for (IStackType key : hashSet) {
            long lastCount = lastMap.getOrDefault(key, 0L);
            long nowCount = nowMap.getOrDefault(key, 0L);
            long delta = nowCount - lastCount;
            if (delta == 0L) continue;
            changedItem.add(key.copy());
            changedCount.add(delta);
        }
        if (!changedItem.isEmpty()) {
            int n = 921600;
            ArrayList<DisorderedSlotGroupSyncPacket> packets = new ArrayList<DisorderedSlotGroupSyncPacket>();
            ArrayList<Integer> entrySizes = new ArrayList<Integer>();
            for (int i = 0; i < changedItem.size(); ++i) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.menu.player.level().registryAccess(), ConnectionType.OTHER);
                IStackType stack = (IStackType)changedItem.get(i);
                if (stack != null) {
                    stack.serialize(registryBuf);
                }
                buf.writeLong(((Long)changedCount.get(i)).longValue());
                entrySizes.add(buf.readableBytes());
            }
            ArrayList<IStackType> batchItems = new ArrayList<IStackType>();
            ArrayList<Long> batchCounts = new ArrayList<Long>();
            int currentSize = 0;
            for (int i = 0; i < changedItem.size(); ++i) {
                int entrySize = (Integer)entrySizes.get(i);
                if (currentSize + entrySize > 921600) {
                    packets.add(new DisorderedSlotGroupSyncPacket(this.groupId, new ArrayList<IStackType>(batchItems), new ArrayList<Long>(batchCounts)));
                    batchItems.clear();
                    batchCounts.clear();
                    currentSize = 0;
                }
                batchItems.add((IStackType)changedItem.get(i));
                batchCounts.add((Long)changedCount.get(i));
                currentSize += entrySize;
            }
            if (!batchItems.isEmpty()) {
                packets.add(new DisorderedSlotGroupSyncPacket(this.groupId, batchItems, batchCounts));
            }
            for (DisorderedSlotGroupSyncPacket packet : packets) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.menu.player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public void loadChange(List<IStackType> stacks, List<Long> changedCounts) {
        IStackTypedHandler clientStorage = this.storage;
        int i = 0;
        for (IStackType remoteStack : stacks) {
            if (clientStorage.hasStackType(remoteStack)) {
                if (changedCounts.get(i) > 0L) {
                    clientStorage.insert(remoteStack.copyWithCount(changedCounts.get(i)), false);
                } else {
                    clientStorage.extract(remoteStack.copyWithCount(-changedCounts.get(i).longValue()), false);
                }
            } else if (changedCounts.get(i) > 0L) {
                clientStorage.insert(remoteStack.copyWithCount(changedCounts.get(i)), false);
            }
            ++i;
        }
    }

    @Override
    public void afterLoadChange() {
    }

    public void refreshLast() {
        this.lastStorage.clear();
        for (IStackType stack : this.storage.getStorage()) {
            this.lastStorage.add(stack.copy());
        }
    }
}

