/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.FluidHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Item.Custom.XpExchangeItem;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.ItemCapInteractionBlackList;
import com.wintercogs.beyonddimensions.Tags.ModFluidTags;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.XpUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;

public class DisorderedStackTypedSlot
extends AbstractStackTypedSlot {
    public DisorderedStackTypedSlot(BDBaseMenu menu, IStackTypedHandler stackTypedHandler, int slotIndex, int xPosition, int yPosition) {
        super(menu, stackTypedHandler, slotIndex, xPosition, yPosition);
    }

    public DisorderedStackTypedSlot(BDBaseMenu menu, IStackTypedHandler stackTypedHandler, int slotIndex, int quickMoveSlotStartIndex, int quickMoveSlotEndIndex, int xPosition, int yPosition) {
        super(menu, stackTypedHandler, slotIndex, quickMoveSlotStartIndex, quickMoveSlotEndIndex, xPosition, yPosition);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public void click(IStackType clickStack, int button, Player player) {
        ItemStack carriedItem = this.menu.getCarried().copy();
        if (clickStack.isEmpty()) {
            if (!carriedItem.isEmpty()) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.getItem() instanceof XpExchangeItem && button != 0) {
                    int conversionRate = XpExchangeItem.getConversionRate();
                    double currentLevel = XpUtil.levelAsDouble(player);
                    int wantConversionLevel = XpExchangeItem.getXpLevelPerAction(carriedItem);
                    if (button == 1) {
                        handled.set(true);
                        long needRemovePlayerXp = XpUtil.xpBetweenLevels(Math.max(currentLevel - (double)wantConversionLevel, 0.0), currentLevel);
                        int actualRemovePlayerXp = BDMath.clampLongToInt(needRemovePlayerXp);
                        long actualInsertFluid = (long)actualRemovePlayerXp * (long)conversionRate;
                        IStackType remaining = this.storage.insert(new FluidStackType(new FluidStack(ModFluids.XP_FLUID.source(), 1), actualInsertFluid), false);
                        if (!remaining.isEmpty()) {
                            int needReturnXp = BDMath.clampLongToInt(remaining.getStackAmount() / 20L);
                            actualRemovePlayerXp -= needReturnXp;
                        }
                        player.giveExperiencePoints(-actualRemovePlayerXp);
                    }
                } else if (carriedItem.getCount() == 1 && button == 1 && !ItemCapInteractionBlackList.isInBlackList(carriedItem.getItem())) {
                    Item currentLevel = carriedItem.getItem();
                    if (currentLevel instanceof BucketItem) {
                        int changedCount;
                        int remaining;
                        FluidStackType stack;
                        FluidHandlerWrapper stackHandlerWrapper;
                        BucketItem bucketItem = (BucketItem)currentLevel;
                        Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                        if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty() && (remaining = (int)this.storage.insert(stack.copyWithCount(changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))), true).getStackAmount()) <= 0) {
                            this.storage.insert(stack.copyWithCount(changedCount), false).getStackAmount();
                            this.menu.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                            handled.set(true);
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(cap);
                            if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                    int remaining;
                                    int changedCount;
                                    int actualInsert;
                                    IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                    if (stack == null || stack.isEmpty() || (actualInsert = (changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))) - (remaining = (int)this.storage.insert(stack.copyWithCount(changedCount), false).getStackAmount())) <= 0) continue;
                                    long actualExtracts = stackHandlerWrapper.extract(index, actualInsert, false);
                                    if (actualExtracts < (long)actualInsert) {
                                        this.storage.extract(stack.copyWithCount((long)actualInsert - actualExtracts), false);
                                    }
                                    this.menu.setCarried(carriedItem.copy());
                                    handled.set(true);
                                    break;
                                }
                            }
                        });
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    int actualInsert = (int)((long)changedCount - this.storage.insert(StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false).getStackAmount());
                    int newCount = carriedItem.getCount() - actualInsert;
                    if (newCount <= 0) {
                        this.menu.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.menu.setCarried(newCarriedItem);
                    }
                }
            }
        } else if (this.mayPickup(player)) {
            if (carriedItem.isEmpty()) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickItem = (ItemStackType)clickStack;
                    int woundChangeNum = BDMath.clampLongToInt(Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize()));
                    int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                    ItemStack takenItem = ((ItemStack)this.storage.extract(new ItemStackType(clickItem.copyStackWithCount(actualChangeNum)), false).getStack()).copy();
                    if (takenItem != null) {
                        this.menu.setCarried(takenItem);
                    }
                }
            } else if (this.mayPlace(carriedItem)) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.getItem() instanceof XpExchangeItem && button != 0) {
                    FluidStackType fluidStackType;
                    IStackType actualStack = this.storage.getStackByStack(clickStack);
                    int conversionRate = XpExchangeItem.getConversionRate();
                    double currentLevel = XpUtil.levelAsDouble(player);
                    int wantConversionLevel = XpExchangeItem.getXpLevelPerAction(carriedItem);
                    if (actualStack instanceof FluidStackType && (fluidStackType = (FluidStackType)actualStack).hasTag(ModFluidTags.C_EXPERIENCE)) {
                        handled.set(true);
                        if (button == 1) {
                            long needRemovePlayerXp = XpUtil.xpBetweenLevels(Math.max(currentLevel - (double)wantConversionLevel, 0.0), currentLevel);
                            int actualRemovePlayerXp = BDMath.clampLongToInt(needRemovePlayerXp);
                            long actualInsertFluid = (long)actualRemovePlayerXp * (long)conversionRate;
                            IStackType remaining = this.storage.insert(fluidStackType.copyWithCount(actualInsertFluid), false);
                            if (!remaining.isEmpty()) {
                                int needReturnXp = BDMath.clampLongToInt(remaining.getStackAmount() / 20L);
                                actualRemovePlayerXp -= needReturnXp;
                            }
                            player.giveExperiencePoints(-actualRemovePlayerXp);
                        } else if (button == 2) {
                            long needInsertPlayerXp = XpUtil.xpBetweenLevels(currentLevel, currentLevel + (double)wantConversionLevel);
                            int actualInsertPlayerXp = BDMath.clampLongToInt(needInsertPlayerXp);
                            long actualRemoveFluid = actualInsertPlayerXp * conversionRate;
                            IStackType extracted = this.storage.extract(fluidStackType.copyWithCount(actualRemoveFluid), false);
                            if ((actualInsertPlayerXp = BDMath.clampLongToInt(extracted.getStackAmount() / 20L)) > 0) {
                                player.giveExperiencePoints(actualInsertPlayerXp);
                            }
                        }
                    } else if (button == 1) {
                        handled.set(true);
                        long needRemovePlayerXp = XpUtil.xpBetweenLevels(Math.max(currentLevel - (double)wantConversionLevel, 0.0), currentLevel);
                        int actualRemovePlayerXp = BDMath.clampLongToInt(needRemovePlayerXp);
                        long actualInsertFluid = (long)actualRemovePlayerXp * (long)conversionRate;
                        IStackType remaining = this.storage.insert(new FluidStackType(new FluidStack(ModFluids.XP_FLUID.source(), 1), actualInsertFluid), false);
                        if (!remaining.isEmpty()) {
                            int needReturnXp = BDMath.clampLongToInt(remaining.getStackAmount() / 20L);
                            actualRemovePlayerXp -= needReturnXp;
                        }
                        player.giveExperiencePoints(-actualRemovePlayerXp);
                    }
                } else if (!ItemCapInteractionBlackList.isInBlackList(carriedItem.getItem()) && carriedItem.getCount() == 1 && button == 1) {
                    Item conversionRate = carriedItem.getItem();
                    if (conversionRate instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)conversionRate;
                        if (bucket == Items.BUCKET) {
                            FluidStackType fluidStackType;
                            Item filledBucket;
                            if (clickStack instanceof FluidStackType && (filledBucket = (fluidStackType = (FluidStackType)clickStack).getStack().getFluid().getBucket()) != null && filledBucket != Items.AIR && this.storage.getStackByStack(fluidStackType).getStackAmount() >= 1000L) {
                                this.storage.extract(fluidStackType.copyWithCount(1000L), false);
                                this.menu.setCarried(new ItemStack((ItemLike)filledBucket));
                                handled.set(true);
                            }
                        } else {
                            int changedCount;
                            int remaining;
                            FluidStackType stack;
                            FluidHandlerWrapper stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                            if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty() && (remaining = (int)this.storage.insert(stack.copyWithCount(changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))), true).getStackAmount()) <= 0) {
                                this.storage.insert(stack.copyWithCount(changedCount), false).getStackAmount();
                                this.menu.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                                handled.set(true);
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            int remaining;
                            int changedCount;
                            int actualInsert;
                            IStackType actualClickStack;
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler;
                            if (clickStack.getTypeId().equals(typeId) && (handler = carriedItem.getCapability(cap)) != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0 && (actualClickStack = this.storage.getStackByStack(clickStack)) != null && (actualInsert = (changedCount = BDMath.clampLongToInt(Math.min(actualClickStack.getStackAmount(), actualClickStack.getVanillaMaxStackSize()))) - (remaining = (int)stackHandlerWrapper.insert(actualClickStack.copyStackWithCount(changedCount), false))) > 0) {
                                this.storage.extract(actualClickStack.copyWithCount(actualInsert), false);
                                this.menu.setCarried(carriedItem.copy());
                                handled.set(true);
                            }
                        });
                        if (!handled.get()) {
                            CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                                Function<?, IStackHandlerWrapper<?>> handlerGetter;
                                IStackHandlerWrapper<?> stackHandlerWrapper;
                                Object handler = carriedItem.getCapability(cap);
                                if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                    for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                        int remaining;
                                        int changedCount;
                                        int actualInsert;
                                        IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                        if (stack == null || stack.isEmpty() || (actualInsert = (changedCount = BDMath.clampLongToInt(Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize()))) - (remaining = (int)this.storage.insert(stack.copyWithCount(changedCount), false).getStackAmount())) <= 0) continue;
                                        long actualExtracts = stackHandlerWrapper.extract(index, actualInsert, false);
                                        if (actualExtracts < (long)actualInsert) {
                                            this.storage.extract(stack.copyWithCount((long)actualInsert - actualExtracts), false);
                                        }
                                        this.menu.setCarried(carriedItem.copy());
                                        handled.set(true);
                                        break;
                                    }
                                }
                            });
                        }
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    this.storage.insert(StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false);
                    int newCount = carriedItem.getCount() - changedCount;
                    if (newCount <= 0) {
                        this.menu.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.menu.setCarried(newCarriedItem);
                    }
                }
            } else if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                // empty if block
            }
        }
    }

    @Override
    public void quickMove(IStackType clickStack, int button, Player player) {
        if (this.quickMoveSlotStartIndex < 0 || this.quickMoveSlotEndIndex < 0 || this.quickMoveSlotStartIndex >= this.quickMoveSlotEndIndex) {
            return;
        }
        if (!clickStack.isEmpty()) {
            ItemStackType trueStack = this.storage.getStackByStack(clickStack).copyWithCount(clickStack.getStackAmount());
            for (int targetSlotIndex = this.quickMoveSlotStartIndex; targetSlotIndex < this.quickMoveSlotEndIndex && !trueStack.isEmpty(); ++targetSlotIndex) {
                Slot slot = (Slot)this.menu.slots.get(targetSlotIndex);
                if (slot instanceof AbstractStackTypedSlot) {
                    AbstractStackTypedSlot aSlot = (AbstractStackTypedSlot)slot;
                    IStackType extract = this.storage.extract(trueStack, false);
                    IStackType remaining = aSlot.safeInsert(extract);
                    if (!remaining.isEmpty()) {
                        this.storage.insert(remaining, false);
                    }
                    trueStack = remaining.copy();
                    continue;
                }
                if (!(trueStack instanceof ItemStackType)) continue;
                ItemStackType trueItemTypedStack = trueStack;
                ItemStack extract = (ItemStack)this.storage.extract(trueItemTypedStack, false).getStack();
                ItemStack remaining = slot.safeInsert(extract);
                if (!remaining.isEmpty()) {
                    this.storage.insert(new ItemStackType(remaining), false);
                }
                trueStack = new ItemStackType(remaining.copy());
            }
            this.setChanged();
        }
    }

    @Override
    public IStackType safeInsert(IStackType stack) {
        if (stack != null) {
            return this.storage.insert(stack, false);
        }
        return new ItemStackType();
    }

    @Override
    public IStackType safeExtract(IStackType stack) {
        if (stack != null) {
            return this.storage.extract(stack, false);
        }
        return new ItemStackType();
    }

    @Override
    public void updateChange() {
    }

    @Override
    public void loadChange(int where, IStackType newStack, long newAmount) {
    }
}

