/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Tester;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GameTester {
    public static void OnSeverStartTester(MinecraftServer server) {
        int j;
        List allItems = BuiltInRegistries.ITEM.stream().filter(item -> item != Items.AIR).collect(Collectors.toList());
        BeyondDimensions.LOGGER.info("============= \u5b58\u50a8\u7cfb\u7edf\u6027\u80fd\u6d4b\u8bd5\u62a5\u544a =============");
        int totalTestTimes = 2000;
        ArrayList allInsertData = new ArrayList(2000);
        ArrayList<Object> allExtractData = new ArrayList<Object>(2000);
        Random masterRandom = new Random(42L);
        for (int i = 0; i < 2000; ++i) {
            ArrayList shuffledItems = new ArrayList(allItems);
            Collections.shuffle(shuffledItems, new Random(masterRandom.nextLong()));
            ArrayList<ItemStackType> insertData = new ArrayList<ItemStackType>();
            for (Item item2 : shuffledItems) {
                int amount = 100 + masterRandom.nextInt(201);
                insertData.add(new ItemStackType(new ItemStack((ItemLike)item2, amount)));
            }
            allInsertData.add(insertData);
            Object extractData = new int[allItems.size()];
            for (j = 0; j < ((Object)extractData).length; ++j) {
                extractData[j] = masterRandom.nextInt(400);
            }
            allExtractData.add(extractData);
        }
        UnifiedStorage warmupStorage = new UnifiedStorage(new DimensionsNet(true));
        for (int i = 0; i < 50; ++i) {
            List data = (List)allInsertData.get(0);
            for (ItemStackType stack : data) {
                warmupStorage.insert(stack, false);
            }
            int[] extData = (int[])allExtractData.get(0);
            for (j = warmupStorage.getSlots() - 1; j >= 0; --j) {
                warmupStorage.extract(j, extData[j], false);
            }
            warmupStorage.clearStorage();
        }
        long[] insertTimes = new long[2000];
        long[] extractTimes = new long[2000];
        long[] combinedTimes = new long[2000];
        for (int times = 0; times < 2000; ++times) {
            UnifiedStorage storage = new UnifiedStorage(new DimensionsNet(true));
            List insertData = (List)allInsertData.get(times);
            int[] extractData = (int[])allExtractData.get(times);
            long insertStart = System.nanoTime();
            for (ItemStackType stack : insertData) {
                storage.insert(stack, false);
            }
            insertTimes[times] = System.nanoTime() - insertStart;
            storage.clearStorage();
            for (ItemStackType stack : insertData) {
                storage.insert(stack, false);
            }
            long extractStart = System.nanoTime();
            for (int i = storage.getSlots() - 1; i >= 0; --i) {
                storage.extract(i, extractData[i], false);
            }
            extractTimes[times] = System.nanoTime() - extractStart;
            UnifiedStorage combinedStorage = new UnifiedStorage(new DimensionsNet(true));
            long combinedStart = System.nanoTime();
            for (ItemStackType stack : insertData) {
                combinedStorage.insert(stack, false);
            }
            for (int i = combinedStorage.getSlots() - 1; i >= 0; --i) {
                combinedStorage.extract(i, extractData[i], false);
            }
            combinedTimes[times] = System.nanoTime() - combinedStart;
        }
        GameTester.reportPerformance("\u63d2\u5165\u64cd\u4f5c", insertTimes);
        GameTester.reportPerformance("\u63d0\u53d6\u64cd\u4f5c", extractTimes);
        GameTester.reportPerformance("\u63d2\u5165+\u63d0\u53d6\u64cd\u4f5c", combinedTimes);
    }

    private static void reportPerformance(String name, long[] timings) {
        int excludeCount;
        long total = 0L;
        for (long t : timings) {
            total += t;
        }
        long filteredTotal = 0L;
        for (int i = excludeCount = timings.length / 10; i < timings.length; ++i) {
            filteredTotal += timings[i];
        }
        double avgTotal = (double)total / 1000000.0 / (double)timings.length;
        double avgFiltered = (double)filteredTotal / 1000000.0 / (double)(timings.length - excludeCount);
        BeyondDimensions.LOGGER.info("{} \u5e73\u5747\u8017\u65f6: {} ms (\u6392\u9664\u524d{}\u6b21\u540e: {} ms)", new Object[]{name, avgTotal, excludeCount, avgFiltered});
    }
}

