/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ChemicalStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;

public class ChemicalStackTypedHandler
implements IChemicalHandler {
    private StackTypedHandler handlerStorage;

    public ChemicalStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getChemicalTanks() {
        return this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).map(List::size).orElse(0);
    }

    public ChemicalStack getChemicalInTank(int tank) {
        return this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(obj -> (ChemicalStack)obj.getStack()).orElse(ChemicalStack.EMPTY);
    }

    public void setChemicalInTank(int tank, ChemicalStack stack) {
        this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).ifPresent(actualIndex -> this.handlerStorage.setStackDirectly((int)actualIndex, new ChemicalStackType(stack.copy())));
    }

    public long getChemicalTankCapacity(int tank) {
        return 64000L;
    }

    public boolean isValid(int tank, ChemicalStack stack) {
        return true;
    }

    public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> {
            IStackType remainingStack = this.handlerStorage.insert((int)actualIndex, new ChemicalStackType(stack.copy()), action.simulate());
            long remaining = remainingStack.getStackAmount();
            return remaining > 0L ? stack.copyWithAmount(remaining) : ChemicalStack.EMPTY;
        }).orElse(stack.copy());
    }

    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((ChemicalStackType)extracts).copyStack()).orElse(ChemicalStack.EMPTY);
    }

    public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new ChemicalStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return stack.copyWithAmount(remaining);
        }
        return ChemicalStack.EMPTY;
    }

    public ChemicalStack extractChemical(long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(ChemicalStackType.ID).map(slots -> (Integer)slots.getFirst()).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copyWithCount(amount)).map(stack -> this.handlerStorage.extract((IStackType)stack, action.simulate())).map(extracts -> ((ChemicalStackType)extracts).copyStack()).orElse(ChemicalStack.EMPTY);
    }

    public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
        return ((ChemicalStackType)this.handlerStorage.extract(new ChemicalStackType(stack.copy()), action.simulate())).copyStack();
    }
}

