/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.HopperFluidMode;
import com.wintercogs.beyonddimensions.Machine.HopperItemMode;
import com.wintercogs.beyonddimensions.Machine.HopperNBTMode;
import com.wintercogs.beyonddimensions.Machine.HopperRangeMode;
import com.wintercogs.beyonddimensions.Machine.HopperXpMode;
import com.wintercogs.beyonddimensions.Menu.NetHopperMenu;
import com.wintercogs.beyonddimensions.Unit.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class NetHopperBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private static final int capacity = 36;
    private final StackTypedHandler filterSlots = new StackTypedHandler(36){

        @Override
        public void onChange() {
            if (!NetHopperBlockEntity.this.level.isClientSide()) {
                NetHopperBlockEntity.this.level.blockEntityChanged(NetHopperBlockEntity.this.worldPosition);
            }
        }
    };
    public FilterMode filterMode = FilterMode.BLACK;
    public HopperItemMode hopperItemMode = HopperItemMode.ALLOW;
    public HopperFluidMode hopperFluidMode = HopperFluidMode.DENY;
    public HopperNBTMode hopperNBTMode = HopperNBTMode.DENY;
    public HopperXpMode hopperXpMode = HopperXpMode.DENY;
    public HopperRangeMode hopperRangeMode = HopperRangeMode.RADIUS_MID;
    private List<ItemEntity> itemEntities = new ArrayList<ItemEntity>();
    private List<ExperienceOrb> xpEntities = new ArrayList<ExperienceOrb>();

    public NetHopperBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_HOPPER_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public boolean shouldWork() {
        return super.shouldWork() && this.getNet() != null;
    }

    @Override
    public int getTicksPerWork() {
        return switch (this.hopperRangeMode) {
            default -> throw new MatchException(null, null);
            case HopperRangeMode.RADIUS_LOWEST -> 5;
            case HopperRangeMode.RADIUS_LOW -> 10;
            case HopperRangeMode.RADIUS_MID -> 20;
            case HopperRangeMode.RADIUS_HIGH -> 60;
            case HopperRangeMode.RADIUS_HIGHEST -> 100;
            case HopperRangeMode.CHUNK_MODE -> 1200;
        };
    }

    @Override
    public void workStart() {
        AABB searchArea = this.getSearchArea();
        if (this.hopperItemMode == HopperItemMode.ALLOW) {
            this.refreshItemEntityCache(searchArea);
        }
        if (this.hopperXpMode == HopperXpMode.ALLOW) {
            this.refreshXpEntityCache(searchArea);
        }
    }

    @Override
    public void workContent() {
        UnifiedStorage storage = this.getNet().getUnifiedStorage();
        if (this.hopperItemMode == HopperItemMode.ALLOW) {
            for (ItemEntity itemEntity : this.itemEntities) {
                ItemStack itemStack;
                ItemStackType typedStack;
                if (itemEntity == null || itemEntity.isRemoved() || !this.matchesFilter(typedStack = new ItemStackType(itemStack = itemEntity.getItem().copy())) || !storage.insert(typedStack, true).isEmpty()) continue;
                itemEntity.discard();
                storage.insert(typedStack, false);
            }
        }
        if (this.hopperXpMode == HopperXpMode.ALLOW) {
            for (ExperienceOrb orb : this.xpEntities) {
                int xp;
                if (orb == null || orb.isRemoved() || (xp = orb.getValue()) <= 0) continue;
                long xpFluid = (long)xp * 20L;
                FluidStackType xpStack = new FluidStackType(new FluidStack(ModFluids.XP_FLUID.source(), 1), xpFluid);
                if (!storage.insert(xpStack, true).isEmpty()) continue;
                orb.discard();
                storage.insert(xpStack, false);
            }
        }
        if (this.hopperFluidMode == HopperFluidMode.ALLOW) {
            this.fluidCollect(this.getSearchArea());
        }
    }

    private AABB getSearchArea() {
        if (this.hopperRangeMode != HopperRangeMode.CHUNK_MODE) {
            int radius = switch (this.hopperRangeMode) {
                case HopperRangeMode.RADIUS_LOWEST -> 2;
                case HopperRangeMode.RADIUS_LOW -> 3;
                case HopperRangeMode.RADIUS_MID -> 5;
                case HopperRangeMode.RADIUS_HIGH -> 7;
                case HopperRangeMode.RADIUS_HIGHEST -> 10;
                default -> 1;
            };
            return new AABB((double)(this.worldPosition.getX() - radius), (double)(this.worldPosition.getY() - radius), (double)(this.worldPosition.getZ() - radius), (double)(this.worldPosition.getX() + radius), (double)(this.worldPosition.getY() + radius), (double)(this.worldPosition.getZ() + radius));
        }
        int chunkX = SectionPos.blockToSectionCoord((int)this.worldPosition.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)this.worldPosition.getZ());
        int minX = chunkX << 4;
        int maxX = minX + 15;
        int minZ = chunkZ << 4;
        int maxZ = minZ + 15;
        int minY = this.level.getMinBuildHeight();
        int maxY = this.level.getMaxBuildHeight();
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private void refreshItemEntityCache(AABB searchArea) {
        this.itemEntities = this.level.getEntitiesOfClass(ItemEntity.class, searchArea, itemEntity -> {
            if (this.hopperNBTMode == HopperNBTMode.DENY) {
                return !ItemStackHelper.hasExtraComponents(itemEntity.getItem());
            }
            return true;
        });
    }

    private void refreshXpEntityCache(AABB searchArea) {
        this.xpEntities = this.level.getEntitiesOfClass(ExperienceOrb.class, searchArea, orb -> true);
    }

    private void fluidCollect(AABB searchArea) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        int minX = Mth.floor((double)searchArea.minX);
        int minY = Mth.floor((double)searchArea.minY);
        int minZ = Mth.floor((double)searchArea.minZ);
        int maxX = Mth.floor((double)searchArea.maxX);
        int maxY = Mth.floor((double)searchArea.maxY);
        int maxZ = Mth.floor((double)searchArea.maxZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    pos.set(x, y, z);
                    FluidState fluidState = this.level.getFluidState((BlockPos)pos);
                    if (fluidState.isEmpty()) continue;
                    int amount = fluidState.isSource() ? 1000 : 0;
                    FluidStack extracted = new FluidStack(fluidState.getType(), amount);
                    UnifiedStorage storage = this.getNet().getUnifiedStorage();
                    FluidStackType typedFluid = new FluidStackType(extracted);
                    if (!this.matchesFilter(typedFluid) || !storage.insert(typedFluid, true).isEmpty()) continue;
                    storage.insert(typedFluid, false);
                    this.level.setBlock((BlockPos)pos, Blocks.AIR.defaultBlockState(), 11);
                }
            }
        }
    }

    private boolean matchesFilter(IStackType otherStack) {
        switch (this.filterMode) {
            case BLACK: {
                for (IStackType stack : this.filterSlots.getStorage()) {
                    if (!stack.isSame(otherStack)) continue;
                    return false;
                }
                return true;
            }
            case WHITE: {
                for (IStackType stack : this.filterSlots.getStorage()) {
                    if (!stack.isSame(otherStack)) continue;
                    return true;
                }
                return false;
            }
            case IGNORE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.filterSlots.deserializeNBT(registries, tag.getCompound("filter_slots"));
        this.filterMode = FilterMode.valueOf(tag.getString("filter_type"));
        this.hopperFluidMode = HopperFluidMode.valueOf(tag.getString("hopper_fluid_mode"));
        this.hopperNBTMode = HopperNBTMode.valueOf(tag.getString("hopper_nbt_mode"));
        this.hopperRangeMode = HopperRangeMode.valueOf(tag.getString("hopper_range_mode"));
        this.hopperItemMode = tag.contains("hopper_item_model") ? HopperItemMode.valueOf(tag.getString("hopper_item_model")) : null;
        this.hopperXpMode = tag.contains("hopper_xp_mode") ? HopperXpMode.valueOf(tag.getString("hopper_xp_mode")) : null;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("filter_slots", (Tag)this.filterSlots.serializeNBT(registries));
        tag.putString("filter_type", this.filterMode.name());
        tag.putString("hopper_fluid_mode", this.hopperFluidMode.name());
        tag.putString("hopper_nbt_mode", this.hopperNBTMode.name());
        tag.putString("hopper_range_mode", this.hopperRangeMode.name());
        tag.putString("hopper_item_model", this.hopperItemMode.name());
        tag.putString("hopper_xp_mode", this.hopperXpMode.name());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.title.beyonddimensions.hopper_menu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new NetHopperMenu(containerId, inventory, this.filterSlots, this);
    }
}

