/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.JEI;

import appeng.api.stacks.GenericStack;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.Registry.StackTypeRegistry;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.Integration.AE.AEHelper;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Packet.SetSlotDirectlyPacket;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetInterfaceGhostHandler
implements IGhostIngredientHandler<BDBaseGUI> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(BDBaseGUI screen, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (Slot slot : screen.getMenu().slots) {
            if (!slot.isActive() || !slot.isFake() || !(slot instanceof AbstractStackTypedSlot)) continue;
            AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            targets.add(new IStackTarget(sSlot, screen));
        }
        return targets;
    }

    public void onComplete() {
    }

    private static class IStackTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final AbstractStackTypedSlot slot;
        private final Rect2i area;

        public IStackTarget(AbstractStackTypedSlot slot, BDBaseGUI screen) {
            this.slot = slot;
            this.area = new Rect2i(screen.getGuiLeft() + slot.x, screen.getGuiTop() + slot.y, 16, 16);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            I stackKey = ingredient;
            IStackType<ItemStack> dragging = new ItemStackType();
            for (IStackType<?> type : StackTypeRegistry.getAllTypes()) {
                if (!type.getStackClass().isAssignableFrom(stackKey.getClass())) continue;
                dragging = type.getEmpty();
                dragging.setStack((ItemStack)ingredient);
                break;
            }
            if (BeyondDimensions.AELoaded && dragging instanceof ItemStackType) {
                GenericStack genericContent;
                ItemStackType draggingItem = dragging;
                if (!dragging.isEmpty() && (genericContent = GenericStack.fromItemStack((ItemStack)draggingItem.getStack())) != null) {
                    dragging = AEHelper.fromAEKeyToIStack(genericContent.what(), 1L).orElse(new ItemStackType());
                }
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new SetSlotDirectlyPacket(this.slot.index, dragging), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

