/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.HopperFluidMode;
import com.wintercogs.beyonddimensions.Machine.HopperItemMode;
import com.wintercogs.beyonddimensions.Machine.HopperNBTMode;
import com.wintercogs.beyonddimensions.Machine.HopperRangeMode;
import com.wintercogs.beyonddimensions.Machine.HopperXpMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.FlagStackTypedSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NetMagnetMenu
extends BDBaseMenu {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetMagnetMenu>> Net_Magnet_Menu = MENU_TYPES.register("net_magnet_menu", () -> IMenuTypeExtension.create(NetMagnetMenu::new));
    private static final int slotStartY = 25;
    private static final int invSlotStartY = 111;
    private final IStackTypedHandler storage = new StackTypedHandler(36){

        @Override
        public void onChange() {
            super.onChange();
            if (!NetMagnetMenu.this.player.level().isClientSide() && NetMagnetMenu.this.initialized) {
                NetMagnetMenu.this.menuStack.set(ModDataComponents.ISTACK_SLOTS, new ArrayList<IStackType>(NetMagnetMenu.this.storage.getStorage()));
            }
        }
    };
    private boolean initialized;
    public final ItemStack menuStack;
    private RedStoneControlMode lastControlMode;
    private FilterMode lastFilterMode;
    private HopperItemMode lastHopperItemMode;
    private HopperXpMode lastHopperXpMode;
    private HopperNBTMode lastHopperNBTMode;
    private HopperFluidMode lastHopperFluidMode;
    private HopperRangeMode lastHopperRangeMode;

    public NetMagnetMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, playerInventory.player.getItemInHand((InteractionHand)data.readEnum(InteractionHand.class)));
    }

    public NetMagnetMenu(int containerId, Inventory playerInventory, ItemStack menuStack) {
        super(Net_Magnet_Menu.get(), containerId, playerInventory);
        this.menuStack = menuStack;
        this.initialized = false;
        if (!playerInventory.player.level().isClientSide()) {
            List stacks = (List)menuStack.getOrDefault(ModDataComponents.ISTACK_SLOTS, new ArrayList());
            for (int i = 0; i < stacks.size(); ++i) {
                this.storage.insert(i, ((IStackType)stacks.get(i)).copy(), false);
            }
        }
        this.initialized = true;
        this.addPlayerInv(playerInventory);
        this.addFlagSlots();
    }

    private void addFlagSlots() {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                FlagStackTypedSlot flagSlot = new FlagStackTypedSlot(this, this.storage, row * 9 + col, 8 + col * 18, 25 + row * 18);
                this.addSlot(flagSlot);
            }
        }
    }

    private void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 111 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 169));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    @Override
    public boolean stillValid(Player player) {
        return this.menuStack != null && !this.menuStack.isEmpty();
    }

    @Override
    protected boolean shouldSendQuickData() {
        boolean result;
        boolean bl = result = super.shouldSendQuickData() || this.lastControlMode != this.menuStack.get(ModDataComponents.CONTROL_MODE) || this.lastFilterMode != this.menuStack.get(ModDataComponents.FILTER_MODE) || this.lastHopperItemMode != this.menuStack.get(ModDataComponents.HOPPER_ITEM_MODE) || this.lastHopperXpMode != this.menuStack.get(ModDataComponents.HOPPER_XP_MODE) || this.lastHopperNBTMode != this.menuStack.get(ModDataComponents.HOPPER_NBT_MODE) || this.lastHopperFluidMode != this.menuStack.get(ModDataComponents.HOPPER_FLUID_MODE) || this.lastHopperRangeMode != this.menuStack.get(ModDataComponents.HOPPER_RANGE_MODE);
        if (result) {
            this.lastControlMode = (RedStoneControlMode)((Object)this.menuStack.get(ModDataComponents.CONTROL_MODE));
            this.lastFilterMode = (FilterMode)((Object)this.menuStack.get(ModDataComponents.FILTER_MODE));
            this.lastHopperItemMode = (HopperItemMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_ITEM_MODE));
            this.lastHopperXpMode = (HopperXpMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_XP_MODE));
            this.lastHopperNBTMode = (HopperNBTMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_NBT_MODE));
            this.lastHopperFluidMode = (HopperFluidMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_FLUID_MODE));
            this.lastHopperRangeMode = (HopperRangeMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_RANGE_MODE));
        }
        return result;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.putString("filter_type", ((FilterMode)((Object)this.menuStack.get(ModDataComponents.FILTER_MODE))).name());
        tag.putString("control_mode", ((RedStoneControlMode)((Object)this.menuStack.get(ModDataComponents.CONTROL_MODE))).name());
        tag.putString("hopper_item_mode", ((HopperItemMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_ITEM_MODE))).name());
        tag.putString("hopper_xp_mode", ((HopperXpMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_XP_MODE))).name());
        tag.putString("hopper_nbt_mode", ((HopperNBTMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_NBT_MODE))).name());
        tag.putString("hopper_fluid_mode", ((HopperFluidMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_FLUID_MODE))).name());
        tag.putString("hopper_range_mode", ((HopperRangeMode)((Object)this.menuStack.get(ModDataComponents.HOPPER_RANGE_MODE))).name());
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        this.menuStack.set(ModDataComponents.FILTER_MODE, (Object)FilterMode.valueOf(tag.getString("filter_type")));
        this.menuStack.set(ModDataComponents.CONTROL_MODE, (Object)RedStoneControlMode.valueOf(tag.getString("control_mode")));
        this.menuStack.set(ModDataComponents.HOPPER_ITEM_MODE, (Object)HopperItemMode.valueOf(tag.getString("hopper_item_mode")));
        this.menuStack.set(ModDataComponents.HOPPER_XP_MODE, (Object)HopperXpMode.valueOf(tag.getString("hopper_xp_mode")));
        this.menuStack.set(ModDataComponents.HOPPER_NBT_MODE, (Object)HopperNBTMode.valueOf(tag.getString("hopper_nbt_mode")));
        this.menuStack.set(ModDataComponents.HOPPER_FLUID_MODE, (Object)HopperFluidMode.valueOf(tag.getString("hopper_fluid_mode")));
        this.menuStack.set(ModDataComponents.HOPPER_RANGE_MODE, (Object)HopperRangeMode.valueOf(tag.getString("hopper_range_mode")));
    }
}

