/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.MatterCompressionBall;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class NetInterfaceBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private static final int capacity = 27;
    private final StackTypedHandler fakeStackHandler = new StackTypedHandler(27){

        @Override
        public void onChange() {
            if (!NetInterfaceBlockEntity.this.level.isClientSide()) {
                NetInterfaceBlockEntity.this.level.blockEntityChanged(NetInterfaceBlockEntity.this.worldPosition);
            }
        }
    };
    private final StackTypedHandler stackHandler = new StackTypedHandler(27){

        @Override
        public void onChange() {
            if (!NetInterfaceBlockEntity.this.level.isClientSide()) {
                NetInterfaceBlockEntity.this.level.blockEntityChanged(NetInterfaceBlockEntity.this.worldPosition);
            }
        }
    };
    public PopMode popMode = PopMode.STOP;
    private final Direction[] directions = Direction.values();
    private final Multimap<ResourceLocation, Object> handlerCache = ArrayListMultimap.create();
    private boolean needsCapabilityUpdate = true;

    public StackTypedHandler getStackHandler() {
        return this.stackHandler;
    }

    public StackTypedHandler getFakeStackHandler() {
        return this.fakeStackHandler;
    }

    public NetInterfaceBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_INTERFACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public boolean shouldWork() {
        return super.shouldWork();
    }

    @Override
    public void workContent() {
        super.workContent();
        if (this.getNet() != null) {
            this.transferToNet();
            this.transferFromNet();
        }
        if (this.popMode == PopMode.OPEN) {
            this.updateCapabilityCache();
            this.popStack();
        }
    }

    public void updateCapabilityCache() {
        if (this.level == null || !this.needsCapabilityUpdate) {
            return;
        }
        this.handlerCache.clear();
        for (Direction dir : this.directions) {
            BlockPos targetPos = this.getBlockPos().relative(dir);
            BlockEntity neighbor = this.level.getBlockEntity(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity) continue;
            CapabilityHelper.BlockCapabilityMap.forEach((resourceLocation, cap) -> {
                Object handler = this.level.getCapability(cap, targetPos, (Object)dir.getOpposite());
                if (handler != null) {
                    this.handlerCache.put(resourceLocation, handler);
                }
            });
        }
        this.needsCapabilityUpdate = false;
    }

    public void setNeedsCapabilityUpdate() {
        this.needsCapabilityUpdate = true;
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.setNeedsCapabilityUpdate();
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        CapabilityHelper.BlockCapabilityMap.forEach((resourceLocation, directionBlockCapability) -> {
            Function<StackTypedHandler, Object> handler = StackTypedHandler.typedHandlerMap.get(resourceLocation);
            event.registerBlockEntity(directionBlockCapability, ModBlockEntities.NET_INTERFACE_BLOCK_ENTITY.get(), (be, side) -> handler.apply(be.stackHandler));
        });
    }

    public void transferToNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < 27; ++i) {
                IStackType stack;
                IStackType flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag != null && !flag.isEmpty() && flag.isSameTypeSameComponents(this.stackHandler.getStackBySlot(i)) || (stack = this.stackHandler.getStackBySlot(i)) == null || stack.isEmpty()) continue;
                net.getUnifiedStorage().insert(stack.copy(), false);
                this.stackHandler.setStackDirectly(i, new ItemStackType());
            }
        }
    }

    public void transferFromNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < 27; ++i) {
                IStackType remaining;
                IStackType stack;
                IStackType current;
                IStackType flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag == null || flag.isEmpty() || (current = this.stackHandler.getStorage().get(i)) != null && !current.isEmpty() && (current.getVanillaMaxStackSize() >= current.getStackAmount() || !current.isSameTypeSameComponents(flag.copy())) || (stack = net.getUnifiedStorage().extract(flag.copyWithCount(flag.getVanillaMaxStackSize()), false)) == null || stack.isEmpty() || (remaining = this.stackHandler.insert(i, stack.copy(), false)).getStackAmount() >= stack.getStackAmount()) continue;
                net.getUnifiedStorage().insert(remaining.copy(), false);
            }
        }
    }

    public void popStack() {
        this.handlerCache.forEach((typeId, handler) -> {
            Function<?, IStackHandlerWrapper<?>> handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId);
            IStackHandlerWrapper<?> stackHandlerWrapper = handlerGetter.apply(handler);
            block0: for (int i = 0; i < 27; ++i) {
                if (!this.fakeStackHandler.getStackBySlot(i).getTypeId().equals(typeId) || !this.fakeStackHandler.getStackBySlot(i).isSameTypeSameComponents(this.stackHandler.getStackBySlot(i))) continue;
                IStackType current = this.stackHandler.getStackBySlot(i).copy();
                for (int slot = 0; slot < stackHandlerWrapper.getSlots(); ++slot) {
                    long remainging = stackHandlerWrapper.insert(slot, current.copyStack(), false);
                    long extract = current.getStackAmount() - remainging;
                    this.stackHandler.extract(i, extract, false);
                    current.shrink(extract);
                    if (current.isEmpty()) continue block0;
                }
            }
        });
    }

    public void dropContent() {
        ArrayList dropList = new ArrayList();
        for (IStackType stack : this.stackHandler.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                ItemStackType itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().getItem() instanceof MatterCompressionBall) {
                    Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        ItemStack ball = new ItemStack((ItemLike)ModItems.MATTER_COMPRESS_BALL.get(), 1);
        if (!dropList.isEmpty()) {
            ball.set(ModDataComponents.ISTACK_SLOTS, dropList);
            Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)ball);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.stackHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.fakeStackHandler.deserializeNBT(registries, tag.getCompound("flags"));
        String popModeNew = tag.getString("popMode");
        this.popMode = !popModeNew.isEmpty() ? PopMode.valueOf(popModeNew) : (tag.getBoolean("popMode") ? PopMode.OPEN : PopMode.STOP);
        this.setNeedsCapabilityUpdate();
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.stackHandler.serializeNBT(registries));
        tag.put("flags", (Tag)this.fakeStackHandler.serializeNBT(registries));
        tag.putString("popMode", this.popMode.name());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.title.beyonddimensions.net_interface_menu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new NetInterfaceBaseMenu(containerId, player.getInventory(), this.getStackHandler(), this.getFakeStackHandler(), this);
    }

    @Override
    public int getTicksPerWork() {
        return 9;
    }
}

