/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.Api.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.NetMenuType;
import com.wintercogs.beyonddimensions.GUI.SharedWidget.IconButton;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.ReverseButton;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.SearchToggleButton;
import com.wintercogs.beyonddimensions.GUI.Widget.Button.SortMethodButton;
import com.wintercogs.beyonddimensions.GUI.Widget.Scroller.BigScroller;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Packet.OpenNetGuiPacket;
import com.wintercogs.beyonddimensions.ShortCutKey.DimensionsShortKeys;
import com.wintercogs.beyonddimensions.Unit.UIDataHelper;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lwjgl.glfw.GLFW;

public class DimensionsNetGUI<T extends DimensionsNetMenu>
extends BDBaseGUI<T> {
    protected static final ResourceLocation GUI_TEXTURE_TOP_BASE = ResourceLocation.parse((String)"beyonddimensions:textures/gui/top_base.png");
    protected static final int TOP_BASE_WIDTH = 194;
    protected static final int TOP_BASE_HEIGHT = 24;
    protected static final ResourceLocation GUI_TEXTURE_TOP_SLOTS = ResourceLocation.parse((String)"beyonddimensions:textures/gui/top_slots.png");
    protected static final int TOP_SLOTS_WIDTH = 194;
    protected static final int TOP_SLOTS_HEIGHT = 18;
    protected static final ResourceLocation GUI_TEXTURE_MID_SLOTS = ResourceLocation.parse((String)"beyonddimensions:textures/gui/mid_slots.png");
    protected static final int MID_SLOTS_WIDTH = 194;
    protected static final int MID_SLOTS_HEIGHT = 18;
    protected static final ResourceLocation GUI_TEXTURE_BOTTOM_SLOTS = ResourceLocation.parse((String)"beyonddimensions:textures/gui/bottom_slots.png");
    protected static final int BOTTOM_SLOTS_WIDTH = 194;
    protected static final int BOTTOM_SLOTS_HEIGHT = 26;
    protected static final ResourceLocation GUI_TEXTURE_PLAYER_INV = ResourceLocation.parse((String)"beyonddimensions:textures/gui/player_inv.png");
    protected static final int PLAYER_INV_WIDTH = 176;
    protected static final int PLAYER_INV_HEIGHT = 89;
    protected EditBox searchField;
    protected String lastSearchText = "";
    protected ReverseButton reverseButton;
    protected SortMethodButton sortButton;
    protected SearchToggleButton searchToggleButton;
    protected IconButton addPageButton;
    protected IconButton removePageButton;
    protected IconButton craftButton;
    protected BigScroller scroller;
    private boolean isTransferMode = false;

    public DimensionsNetGUI(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void init() {
        int maxLines;
        this.clearWidgets();
        if (UIDataHelper.isTransfer) {
            ((DimensionsNetMenu)this.menu).lineData = UIDataHelper.currentPage;
            if (UIDataHelper.lastMousePos != null) {
                Window window = Minecraft.getInstance().getWindow();
                GLFW.glfwSetCursorPos((long)window.getWindow(), (double)UIDataHelper.lastMousePos.x, (double)UIDataHelper.lastMousePos.y);
            }
            UIDataHelper.isTransfer = false;
        }
        if ((maxLines = this.calMaxLines()) < ((DimensionsNetMenu)this.menu).getLines()) {
            if (maxLines < 2) {
                maxLines = 2;
            }
            ((DimensionsNetMenu)this.menu).setLines(maxLines);
            ((DimensionsNetMenu)this.menu).rebuildSlots();
        }
        this.imageWidth = 194;
        this.imageHeight = this.rebuildImageHeight();
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.rebuildLabelHeight();
        this.sortButton = new SortMethodButton(this.leftPos - 18, this.topPos + 6, button -> {
            this.sortButton.toggleState();
            Config.uiSortButton = (ButtonState)this.sortButton.currentState;
            Config.UI_SORT_BUTTON.set((Object)((ButtonState)this.sortButton.currentState));
            Config.UI_SORT_BUTTON.save();
            ((DimensionsNetMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsNetMenu)this.menu).viewerStorage.getStorage()), true);
        });
        this.addRenderableWidget((GuiEventListener)this.sortButton);
        this.reverseButton = new ReverseButton(this.leftPos - 18, this.topPos + 6 + 18, button -> {
            this.reverseButton.toggleState();
            Config.uiReverseButton = (ButtonState)this.reverseButton.currentState;
            Config.UI_REVERSE_BUTTON.set((Object)((ButtonState)this.reverseButton.currentState));
            Config.UI_REVERSE_BUTTON.save();
            ((DimensionsNetMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsNetMenu)this.menu).viewerStorage.getStorage()), true);
        });
        this.addRenderableWidget((GuiEventListener)this.reverseButton);
        this.searchToggleButton = new SearchToggleButton(this.leftPos - 18, this.topPos + 6 + 36, button -> {
            this.searchToggleButton.toggleState();
            Config.uiSearchButton = (ButtonState)this.searchToggleButton.currentState;
            Config.UI_SEARCH_BUTTON.set((Object)((ButtonState)this.searchToggleButton.currentState));
            Config.UI_SEARCH_BUTTON.save();
        });
        this.addRenderableWidget((GuiEventListener)this.searchToggleButton);
        this.addPageButton = new IconButton(this.leftPos - 18, this.topPos + 6 + 54, 16, 16, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/up_arrow"), button -> {
            if (this.height - 36 <= this.rebuildImageHeight() + 18 || ((DimensionsNetMenu)this.menu).getLines() >= 99) {
                return;
            }
            ((DimensionsNetMenu)this.menu).addLines();
            Config.uiPageNum = ((DimensionsNetMenu)this.menu).getLines();
            Config.UI_PAGE_NUM.set((Object)((DimensionsNetMenu)this.menu).getLines());
            Config.UI_PAGE_NUM.save();
            Config.uiSearch = this.searchField.getValue();
            this.imageHeight = this.rebuildImageHeight();
            ((DimensionsNetMenu)this.menu).rebuildSlots();
            ((DimensionsNetMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsNetMenu)this.menu).viewerStorage.getStorage()), true);
            this.init();
        });
        this.addPageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.add_page")));
        this.addRenderableWidget((GuiEventListener)this.addPageButton);
        this.removePageButton = new IconButton(this.leftPos - 18, this.topPos + 6 + 72, 16, 16, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/down_arrow"), button -> {
            if (((DimensionsNetMenu)this.menu).getLines() <= 2) {
                return;
            }
            ((DimensionsNetMenu)this.menu).reduceLines();
            Config.uiPageNum = ((DimensionsNetMenu)this.menu).getLines();
            Config.UI_PAGE_NUM.set((Object)((DimensionsNetMenu)this.menu).getLines());
            Config.UI_PAGE_NUM.save();
            Config.uiSearch = this.searchField.getValue();
            this.imageHeight = this.rebuildImageHeight();
            ((DimensionsNetMenu)this.menu).rebuildSlots();
            ((DimensionsNetMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsNetMenu)this.menu).viewerStorage.getStorage()), true);
            this.init();
        });
        this.removePageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.remove_page")));
        this.addRenderableWidget((GuiEventListener)this.removePageButton);
        this.addCraftButton();
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.searchField = new EditBox(font, this.leftPos + 60, this.topPos + 7, 120, 9 + 5, (Component)Component.translatable((String)"wintercogs.beyonddimensions.dimensionsguisearch"));
        this.searchField.setMaxLength(200);
        this.searchField.setBordered(true);
        this.searchField.setVisible(true);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.setValue(Config.uiSearch);
        this.searchField.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.editbox.beyonddimensions.search")));
        if (!this.searchField.getValue().equals("")) {
            this.searchField.setSuggestion(null);
        } else {
            this.searchField.setSuggestion(Component.translatable((String)"wintercogs.beyonddimensions.dimensionsguisearch").getString());
        }
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.scroller = new BigScroller(this.leftPos + 174, this.topPos + 24 + 1, 18 * ((DimensionsNetMenu)this.menu).getLines() - 15 - 2, 0, ((DimensionsNetMenu)this.menu).maxLineData);
        this.addRenderableWidget((GuiEventListener)this.scroller);
        this.lastSearchText = this.searchField.getValue();
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (!Objects.equals(this.lastSearchText, this.searchField.getValue())) {
            if (!this.searchField.getValue().equals("")) {
                this.searchField.setSuggestion(null);
            } else {
                this.searchField.setSuggestion(Component.translatable((String)"wintercogs.beyonddimensions.dimensionsguisearch").getString());
            }
            ((DimensionsNetMenu)this.menu).loadSearchText(this.searchField.getValue());
            Config.uiSearch = this.searchField.getValue();
            ((DimensionsNetMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsNetMenu)this.menu).viewerStorage.getStorage()), true);
            this.lastSearchText = this.searchField.getValue();
        }
        this.scroller.updateScrollPosition(((DimensionsNetMenu)this.menu).lineData, ((DimensionsNetMenu)this.menu).maxLineData);
    }

    protected void addCraftButton() {
        this.craftButton = new IconButton(this.leftPos - 18, this.topPos + 6 + 90, 16, 16, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/craft_button"), button -> {
            UIDataHelper.currentPage = ((DimensionsNetMenu)this.menu).lineData;
            double[] xpos = new double[1];
            double[] ypos = new double[1];
            GLFW.glfwGetCursorPos((long)Minecraft.getInstance().getWindow().getWindow(), (double[])xpos, (double[])ypos);
            UIDataHelper.lastMousePos = new Vec2((float)xpos[0], (float)ypos[0]);
            UIDataHelper.isTransfer = true;
            if (this.menu instanceof DimensionsCraftMenu) {
                Config.uiCraftButton = ButtonState.DISABLED;
                Config.UI_CRAFT_BUTTON.set((Object)ButtonState.DISABLED);
                Config.UI_CRAFT_BUTTON.save();
                PacketDistributor.sendToServer((CustomPacketPayload)new OpenNetGuiPacket(((DimensionsNetMenu)this.menu).player.getStringUUID(), NetMenuType.NET_MENU), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                Config.uiCraftButton = ButtonState.ENABLED;
                Config.UI_CRAFT_BUTTON.set((Object)ButtonState.ENABLED);
                Config.UI_CRAFT_BUTTON.save();
                PacketDistributor.sendToServer((CustomPacketPayload)new OpenNetGuiPacket(((DimensionsNetMenu)this.menu).player.getStringUUID(), NetMenuType.NET_CRAFT_MENU), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
        this.craftButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.craft_toggle")));
        this.addRenderableWidget((GuiEventListener)this.craftButton);
    }

    protected int rebuildImageHeight() {
        return 42 + (((DimensionsNetMenu)this.menu).getLines() - 2) * 18 + 26 + 89;
    }

    protected void rebuildLabelHeight() {
        this.titleLabelY = 8;
        this.inventoryLabelY = 24 + ((DimensionsNetMenu)this.menu).getLines() * 18 + 5;
    }

    protected int calMaxLines() {
        return (int)((float)(this.height - 36 - 157) / 18.0f + 2.0f);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int drawY = this.topPos;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE_TOP_BASE);
        guiGraphics.blit(GUI_TEXTURE_TOP_BASE, this.leftPos, drawY, 0.0f, 0.0f, 194, 24, 194, 24);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE_TOP_SLOTS);
        guiGraphics.blit(GUI_TEXTURE_TOP_SLOTS, this.leftPos, drawY += 24, 0.0f, 0.0f, 194, 18, 194, 18);
        drawY += 18;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE_MID_SLOTS);
        for (int i = 0; i < ((DimensionsNetMenu)this.menu).getLines() - 2; ++i) {
            guiGraphics.blit(GUI_TEXTURE_MID_SLOTS, this.leftPos, drawY, 0.0f, 0.0f, 194, 18, 194, 18);
            drawY += 18;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE_BOTTOM_SLOTS);
        guiGraphics.blit(GUI_TEXTURE_BOTTOM_SLOTS, this.leftPos, drawY, 0.0f, 0.0f, 194, 26, 194, 26);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE_PLAYER_INV);
        guiGraphics.blit(GUI_TEXTURE_PLAYER_INV, this.leftPos, drawY += 26, 0.0f, 0.0f, 176, 89, 176, 89);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        if (scrollY > 0.0) {
            --((DimensionsNetMenu)this.menu).lineData;
        } else if (scrollY < 0.0) {
            ++((DimensionsNetMenu)this.menu).lineData;
        }
        ((DimensionsNetMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsNetMenu)this.menu).viewerStorage.getStorage()), false);
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        int scrollY = this.scroller.customDragAction(mouseX, mouseY, button, dragX, dragY);
        int lastLine = ((DimensionsNetMenu)this.menu).lineData--;
        if (scrollY <= 0 && scrollY < 0) {
            ++((DimensionsNetMenu)this.menu).lineData;
        }
        if (lastLine != ((DimensionsNetMenu)this.menu).lineData) {
            ((DimensionsNetMenu)this.menu).buildIndexList(new ArrayList<IStackType>(((DimensionsNetMenu)this.menu).viewerStorage.getStorage()), false);
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag;
        super.mouseClicked(mouseX, mouseY, button);
        boolean bl = flag = this.searchField.active && this.searchField.visible && mouseX >= (double)this.searchField.getX() && mouseY >= (double)this.searchField.getY() && mouseX < (double)(this.searchField.getX() + this.searchField.getWidth()) && mouseY < (double)(this.searchField.getY() + this.searchField.getHeight());
        if (!flag) {
            if (this.getFocused() != null && this.getFocused() == this.searchField) {
                this.searchField.setFocused(false);
                this.setFocused(null);
            }
        } else if (button == 1) {
            this.searchField.setValue("");
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            ((DimensionsNetMenu)this.menu).hasShiftDown = true;
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.searchField.isFocused() && (mouseKey.getValue() >= 48 && mouseKey.getValue() <= 57 || mouseKey.getValue() >= 65 && mouseKey.getValue() <= 90 || mouseKey.getValue() >= 320 && mouseKey.getValue() <= 329 || mouseKey.getValue() == 32)) {
            return true;
        }
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey) || DimensionsShortKeys.OPEN_GUI_KEY.getKey() == mouseKey) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        boolean result = super.keyReleased(keyCode, scanCode, modifiers);
        if (keyCode == 340 || keyCode == 344) {
            ((DimensionsNetMenu)this.menu).updateViewerStorage();
            ((DimensionsNetMenu)this.menu).hasShiftDown = false;
        }
        return result;
    }

    public void removed() {
        super.removed();
        if (this.searchField != null) {
            if (this.searchField.getValue().length() > 0 && Config.uiSearchButton == ButtonState.ENABLED) {
                Config.uiSearch = this.searchField.getValue();
                Config.UI_SEARCH.set((Object)this.searchField.getValue());
                Config.UI_SEARCH.save();
            } else {
                Config.uiSearch = "";
                Config.UI_SEARCH.set((Object)"");
                Config.UI_SEARCH.save();
            }
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }
}

