/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.BaseMachineItem;
import com.wintercogs.beyonddimensions.Item.Custom.NetedItem;
import com.wintercogs.beyonddimensions.Machine.FeederMode;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Menu.NetFeederMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NetFeederItem
extends BaseMachineItem {
    public static final int capacity = 36;

    public NetFeederItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        super.use(level, player, usedHand);
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!level.isClientSide()) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inv, ServerPlayer2) -> new NetFeederMenu(containerId, inv, itemstack), (Component)Component.translatable((String)"menu.title.beyonddimensions.feeder_menu")), buf -> buf.writeEnum((Enum)usedHand));
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    @Override
    public void checkComponents(ItemStack stack) {
        super.checkComponents(stack);
        if (!stack.has(ModDataComponents.ISTACK_SLOTS)) {
            stack.set(ModDataComponents.ISTACK_SLOTS, new ArrayList<ItemStackType>(Collections.nCopies(36, new ItemStackType())));
        }
        if (!stack.has(ModDataComponents.FEEDER_MODE)) {
            stack.set(ModDataComponents.FEEDER_MODE, (Object)FeederMode.NORMAL);
        }
    }

    @Override
    public boolean shouldWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        return super.shouldWork(stack, level, holder, slotId, isSelected) && NetedItem.getNet(stack, level.getServer()) != null;
    }

    @Override
    public void workContent(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        super.workContent(stack, level, holder, slotId, isSelected);
        if (holder instanceof Player) {
            Player player = (Player)holder;
            FeederMode feederMode = (FeederMode)((Object)stack.getOrDefault(ModDataComponents.FEEDER_MODE, (Object)FeederMode.NORMAL));
            List filterSlots = (List)stack.getOrDefault(ModDataComponents.ISTACK_SLOTS, new ArrayList());
            FoodData playerFoodState = player.getFoodData();
            if (this.feederModeMatch(playerFoodState, feederMode)) {
                ItemStackType foodToFeed;
                UnifiedStorage storage = NetedItem.getNet(stack, level.getServer()).getUnifiedStorage();
                IStackType foodCache = null;
                block0: for (IStackType filter : filterSlots) {
                    for (IStackType storedStack : storage.getStorage()) {
                        ItemStackType itemStackType;
                        if (!(storedStack instanceof ItemStackType) || !(itemStackType = (ItemStackType)storedStack).isSame(filter) || !itemStackType.getStack().has(DataComponents.FOOD)) continue;
                        foodCache = storedStack.copyWithCount(1L);
                        continue block0;
                    }
                }
                if (foodCache != null && !(foodToFeed = (ItemStackType)storage.extract(foodCache, false)).isEmpty()) {
                    ItemStack foodStack = foodToFeed.copyStack();
                    Item foodItem = foodStack.getItem();
                    FoodProperties foodProperties = foodItem.getFoodProperties(foodStack, (LivingEntity)player);
                    if (foodProperties != null && (feederMode == FeederMode.SATURATION_KEEP && foodProperties.saturation() > 0.0f || feederMode != FeederMode.SATURATION_KEEP && foodProperties.nutrition() > 0)) {
                        ItemStackType remainingAgain;
                        ItemStack remaining = foodItem.finishUsingItem(foodStack, level, (LivingEntity)player);
                        if (!remaining.isEmpty() && !(remainingAgain = (ItemStackType)storage.insert(new ItemStackType(remaining), false)).isEmpty()) {
                            player.drop(remainingAgain.copyStack(), false);
                        }
                        return;
                    }
                    storage.insert(foodToFeed, false);
                }
            }
        }
    }

    private boolean feederModeMatch(FoodData playerFoodState, FeederMode feederMode) {
        return switch (feederMode) {
            case FeederMode.HUNGER_TO_EAT -> {
                if (playerFoodState.getFoodLevel() <= 2) {
                    yield true;
                }
                yield false;
            }
            case FeederMode.NORMAL -> {
                if (playerFoodState.getFoodLevel() <= 10) {
                    yield true;
                }
                yield false;
            }
            case FeederMode.SATURATION_KEEP -> {
                if (playerFoodState.getSaturationLevel() <= 0.0f) {
                    yield true;
                }
                yield false;
            }
            case FeederMode.CRAZY -> {
                if (playerFoodState.getFoodLevel() < 20) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean matchesFilter(List<IStackType> filterSlots, IStackType otherStack) {
        switch (FilterMode.WHITE) {
            case BLACK: {
                for (IStackType stack : filterSlots) {
                    if (!stack.isSame(otherStack)) continue;
                    return false;
                }
                return true;
            }
            case WHITE: {
                for (IStackType stack : filterSlots) {
                    if (!stack.isSame(otherStack)) continue;
                    return true;
                }
                return false;
            }
            case IGNORE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getTicksPerWork() {
        return 10;
    }
}

