/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.NetedItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NetGifter
extends NetedItem {
    public NetGifter(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        super.use(level, player, usedHand);
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!level.isClientSide()) {
            if ((Integer)itemstack.get(ModDataComponents.NET_ID_DATA) >= 0) {
                DimensionsNet itemNet = DimensionsNet.getNetFromId((Integer)itemstack.get(ModDataComponents.NET_ID_DATA), level.getServer());
                if (itemNet != null) {
                    DimensionsNet playerNet = DimensionsNet.getNetFromPlayer(player);
                    if (playerNet != null && playerNet.getId() != itemNet.getId() && playerNet.isOwner(player)) {
                        int id = itemNet.getId();
                        playerNet.mergeOtherNet(itemNet);
                        itemstack.consume(1, (LivingEntity)player);
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.net_gift_done", (Object[])new Object[]{id}));
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.cant_merge_net"));
                    }
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.error_item_net"));
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.item_need_bound"));
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    @Override
    protected boolean validToReWrite(DimensionsNet net, Player player) {
        return net.isOwner(player);
    }
}

