/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Machine.FeederMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.FlagStackTypedSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NetFeederMenu
extends BDBaseMenu {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetFeederMenu>> Net_Feeder_Menu = MENU_TYPES.register("net_feeder_menu", () -> IMenuTypeExtension.create(NetFeederMenu::new));
    private static final int slotStartY = 25;
    private static final int invSlotStartY = 111;
    private final IStackTypedHandler storage = new StackTypedHandler(36){

        @Override
        public void onChange() {
            super.onChange();
            if (!NetFeederMenu.this.player.level().isClientSide() && NetFeederMenu.this.initialized) {
                NetFeederMenu.this.menuStack.set(ModDataComponents.ISTACK_SLOTS, new ArrayList<IStackType>(NetFeederMenu.this.storage.getStorage()));
            }
        }

        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            ItemStackType itemStackType;
            return super.isStackValid(slot, stack) && stack instanceof ItemStackType && (itemStackType = (ItemStackType)stack).getStack().has(DataComponents.FOOD);
        }
    };
    private boolean initialized;
    public final ItemStack menuStack;
    private RedStoneControlMode lastControlMode;
    private FeederMode lastFeederMode;

    public NetFeederMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, playerInventory.player.getItemInHand((InteractionHand)data.readEnum(InteractionHand.class)));
    }

    public NetFeederMenu(int containerId, Inventory playerInventory, ItemStack menuStack) {
        super(Net_Feeder_Menu.get(), containerId, playerInventory);
        this.menuStack = menuStack;
        this.initialized = false;
        if (!playerInventory.player.level().isClientSide()) {
            List stacks = (List)menuStack.getOrDefault(ModDataComponents.ISTACK_SLOTS, new ArrayList());
            for (int i = 0; i < stacks.size(); ++i) {
                this.storage.insert(i, ((IStackType)stacks.get(i)).copy(), false);
            }
        }
        this.initialized = true;
        this.addPlayerInv(playerInventory);
        this.addFlagSlots();
    }

    private void addFlagSlots() {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                FlagStackTypedSlot flagSlot = new FlagStackTypedSlot(this, this.storage, row * 9 + col, 8 + col * 18, 25 + row * 18);
                this.addSlot(flagSlot);
            }
        }
    }

    private void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 111 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 169));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    @Override
    public boolean stillValid(Player player) {
        return this.menuStack != null && !this.menuStack.isEmpty();
    }

    @Override
    protected boolean shouldSendQuickData() {
        boolean result;
        boolean bl = result = super.shouldSendQuickData() || this.lastControlMode != this.menuStack.get(ModDataComponents.CONTROL_MODE) || this.lastFeederMode != this.menuStack.get(ModDataComponents.FEEDER_MODE);
        if (result) {
            this.lastControlMode = (RedStoneControlMode)((Object)this.menuStack.get(ModDataComponents.CONTROL_MODE));
            this.lastFeederMode = (FeederMode)((Object)this.menuStack.get(ModDataComponents.FEEDER_MODE));
        }
        return result;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.putString("control_mode", ((RedStoneControlMode)((Object)this.menuStack.get(ModDataComponents.CONTROL_MODE))).name());
        tag.putString("feeder_mode", ((FeederMode)((Object)this.menuStack.get(ModDataComponents.FEEDER_MODE))).name());
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        this.menuStack.set(ModDataComponents.CONTROL_MODE, (Object)RedStoneControlMode.valueOf(tag.getString("control_mode")));
        this.menuStack.set(ModDataComponents.FEEDER_MODE, (Object)FeederMode.valueOf(tag.getString("feeder_mode")));
    }
}

