/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Storage.EnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class NetEnergyPathwayBlockEntity
extends NetedBlockEntity {
    public final int transHold = 20;
    public int transTime = 0;
    public boolean popMode = false;
    private final Direction[] directions = Direction.values();
    private EnergyStorage energyStorage = null;

    public NetEnergyPathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_ENERGY_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, ModBlockEntities.NET_ENERGY_PATHWAY_BLOCK_ENTITY.get(), (be, side) -> {
            if (be.popMode) {
                return new net.neoforged.neoforge.energy.EnergyStorage(0);
            }
            if (be.getNetId() < 0) {
                return new net.neoforged.neoforge.energy.EnergyStorage(0);
            }
            DimensionsNet net = be.getNet();
            if (net != null) {
                return net.getEnergyStorage();
            }
            return new net.neoforged.neoforge.energy.EnergyStorage(0);
        });
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NetEnergyPathwayBlockEntity blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        if (blockEntity.getNetId() != -1) {
            ++blockEntity.transTime;
            if (blockEntity.transTime >= blockEntity.transHold) {
                blockEntity.transTime = 0;
            }
        }
        if (blockEntity.popMode && blockEntity.getNetId() >= 0) {
            blockEntity.popEnergy();
        }
    }

    private void popEnergy() {
        if (this.energyStorage == null) {
            this.energyStorage = this.getNet().getEnergyStorage();
        }
        for (Direction dir : this.directions) {
            IEnergyStorage otherStorage;
            BlockPos targetPos = this.getBlockPos().relative(dir);
            BlockEntity neighbor = this.level.getBlockEntity(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity || (otherStorage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, targetPos, (Object)dir.getOpposite())) == null) continue;
            int maxExtract = (int)Math.min(this.energyStorage.getRealEnergyStored(), this.energyStorage.getMaxTransfer());
            int receive = otherStorage.receiveEnergy(maxExtract, false);
            this.energyStorage.extractEnergy(receive, false);
        }
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.energyStorage = null;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.popMode = tag.getBoolean("popMode");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("popMode", this.popMode);
    }
}

