/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Registry.StackTypeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class StackTypedHandler
implements IStackTypedHandler {
    private List<IStackType> storage;
    private final Map<ResourceLocation, List<Integer>> typeIdIndex = new HashMap<ResourceLocation, List<Integer>>();
    public static final Map<ResourceLocation, Function<StackTypedHandler, Object>> typedHandlerMap = new HashMap<ResourceLocation, Function<StackTypedHandler, Object>>();

    public StackTypedHandler(int size) {
        this.storage = new ArrayList<IStackType>(size);
        for (int i = 0; i < size; ++i) {
            this.storage.add(new ItemStackType());
            this.typeIdIndex.computeIfAbsent(ItemStackType.ID, k -> new ArrayList()).add(this.storage.size() - 1);
        }
    }

    @Override
    public List<IStackType> getStorage() {
        return Collections.unmodifiableList(this.storage);
    }

    @Override
    public void onChange() {
    }

    @Override
    public Object getTypedHandler(ResourceLocation typeId) {
        return typedHandlerMap.get(typeId).apply(this);
    }

    @Override
    public int getSlots() {
        return this.storage.size();
    }

    @Override
    public void clearStorage() {
        this.storage.clear();
        this.typeIdIndex.clear();
        this.onChange();
    }

    @Override
    public IStackType getStackBySlot(int slot) {
        return IStackTypedHandler.super.getStackBySlot(slot);
    }

    @Override
    public IStackType getStackByStack(IStackType stackType) {
        ResourceLocation typeId = stackType.getTypeId();
        List<Integer> indices = this.typeIdIndex.get(typeId);
        if (indices != null) {
            for (Integer index : indices) {
                IStackType existing = this.storage.get(index);
                if (!existing.isSameTypeSameComponents(stackType)) continue;
                return existing;
            }
        }
        return null;
    }

    @Override
    public boolean hasStackType(IStackType other) {
        return this.getStackByStack(other) != null;
    }

    @Override
    public void setStackDirectly(int slot, IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        ResourceLocation oldTypeId = this.getStorage().get(slot).getTypeId();
        this.storage.set(slot, stack.copy());
        this.typeIdIndex.computeIfAbsent(oldTypeId, k -> new ArrayList()).remove((Object)slot);
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        this.onChange();
    }

    @Override
    public void addStackToIndexDirectly(int slot, IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        this.storage.add(slot, stack.copy());
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        this.onChange();
    }

    @Override
    public void addStackDirectly(IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        int slot = this.storage.size();
        this.storage.add(stack.copy());
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        this.onChange();
    }

    @Override
    public IStackType insert(int slot, IStackType stack, boolean simulate) {
        IStackType remaining;
        if (slot < 0 || slot >= this.storage.size()) {
            return stack.copy();
        }
        if (!this.isStackValid(slot, stack) || stack.isEmpty()) {
            return stack.copy();
        }
        IStackType current = this.storage.get(slot);
        if (current == null || current.isEmpty()) {
            long maxInsert = Math.min(stack.getStackAmount(), this.getSlotCapacity(slot));
            if ((maxInsert = Math.min(maxInsert, stack.getVanillaMaxStackSize())) <= 0L) {
                return stack.copy();
            }
            remaining = stack.copyWithCount(stack.getStackAmount() - maxInsert);
            if (!simulate) {
                IStackType newStack = stack.copyWithCount(maxInsert);
                ResourceLocation emptyTypeId = current.getTypeId();
                this.typeIdIndex.computeIfAbsent(emptyTypeId, k -> new ArrayList()).remove((Object)slot);
                ResourceLocation newTypeId = stack.getTypeId();
                this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
                this.storage.set(slot, newStack);
                this.onChange();
            }
        } else {
            if (!current.isSameTypeSameComponents(stack)) {
                return stack.copy();
            }
            long slotCap = Math.min(this.getSlotCapacity(slot), stack.getVanillaMaxStackSize());
            long maxInsert = Math.min(stack.getStackAmount(), slotCap - current.getStackAmount());
            if (maxInsert <= 0L) {
                return stack.copy();
            }
            remaining = stack.copyWithCount(stack.getStackAmount() - maxInsert);
            if (!simulate) {
                current.grow(maxInsert);
                this.onChange();
            }
        }
        return remaining;
    }

    @Override
    public IStackType insert(IStackType stack, boolean simulate) {
        IStackType remaining = stack.copy();
        ResourceLocation typeId = stack.getTypeId();
        List<Integer> matchingSlots = this.typeIdIndex.get(typeId);
        if (matchingSlots != null) {
            for (Integer slot : matchingSlots) {
                IStackType current = this.storage.get(slot);
                if (current.isEmpty() || !current.isSameTypeSameComponents(stack) || !(remaining = this.insert(slot, remaining, simulate)).isEmpty()) continue;
                return remaining;
            }
        }
        if (!remaining.isEmpty()) {
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                IStackType current = this.storage.get(slot);
                if (!current.isEmpty() || !(remaining = this.insert(slot, remaining, simulate)).isEmpty()) continue;
                return remaining;
            }
        }
        return remaining;
    }

    @Override
    public IStackType extract(int slot, long count, boolean simulate) {
        if (slot < 0 || slot >= this.storage.size()) {
            return new ItemStackType();
        }
        IStackType current = this.storage.get(slot);
        if (current.isEmpty()) {
            return current.getEmpty();
        }
        long extractable = Math.min(count, current.getStackAmount());
        IStackType extracted = current.copyWithCount(extractable);
        if (!simulate) {
            ResourceLocation oldTypeId = current.getTypeId();
            current.shrink(extractable);
            if (current.isEmpty()) {
                this.storage.set(slot, new ItemStackType());
                this.typeIdIndex.computeIfAbsent(oldTypeId, k -> new ArrayList()).remove((Object)slot);
                this.typeIdIndex.computeIfAbsent(ItemStackType.ID, k -> new ArrayList()).add(slot);
            }
            this.onChange();
        }
        return extracted;
    }

    @Override
    public IStackType extract(IStackType stack, boolean simulate) {
        IStackType result = stack.getEmpty();
        long remaining = stack.getStackAmount();
        ResourceLocation typeId = stack.getTypeId();
        List<Integer> matchingSlots = this.typeIdIndex.get(typeId);
        if (matchingSlots == null || matchingSlots.isEmpty()) {
            return result;
        }
        ArrayList<Integer> slotsToIterate = new ArrayList<Integer>(matchingSlots);
        for (Integer slot : slotsToIterate) {
            IStackType extracted;
            long available;
            long toExtract;
            IStackType current = this.storage.get(slot);
            if (current.isEmpty() || !current.isSameTypeSameComponents(stack) || (toExtract = Math.min(remaining, available = current.getStackAmount())) <= 0L || (extracted = this.extract(slot, toExtract, simulate)).isEmpty()) continue;
            if (result.isEmpty()) {
                result = extracted;
            } else {
                result.grow(extracted.getStackAmount());
            }
            if ((remaining -= extracted.getStackAmount()) > 0L) continue;
            break;
        }
        return result.copyWithCount(stack.getStackAmount() - remaining);
    }

    @Override
    public long getSlotCapacity(int slot) {
        return 64000L;
    }

    @Override
    public boolean isStackValid(int slot, IStackType stack) {
        return true;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag stacksTag = new ListTag();
        for (int i = 0; i < this.getStorage().size(); ++i) {
            IStackType stack = this.getStorage().get(i);
            CompoundTag stackTag = new CompoundTag();
            if (stack.isEmpty()) {
                stackTag.put("TypedStack", (Tag)IntTag.valueOf((int)1));
                stackTag.putString("Type", "Empty");
            } else {
                stackTag.put("TypedStack", (Tag)stack.serializeNBT(provider));
                stackTag.putString("Type", stack.getTypeId().toString());
            }
            stacksTag.add((Object)stackTag);
        }
        tag.put("Stacks", (Tag)stacksTag);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.storage.clear();
        this.typeIdIndex.clear();
        ListTag stacksTag = tag.getList("Stacks", 10);
        for (Tag t : stacksTag) {
            CompoundTag stackTag = (CompoundTag)t;
            String type = stackTag.getString("Type");
            if (type.equals("Empty")) {
                this.storage.add(new ItemStackType());
                this.typeIdIndex.computeIfAbsent(ItemStackType.ID, k -> new ArrayList()).add(this.storage.size() - 1);
                continue;
            }
            ResourceLocation typeId = ResourceLocation.parse((String)type);
            IStackType stackEmpty = StackTypeRegistry.getType(typeId).copy();
            IStackType stackActual = stackEmpty.deserializeNBT(stackTag.getCompound("TypedStack"), provider);
            this.storage.add(stackActual);
            this.typeIdIndex.computeIfAbsent(stackActual.getTypeId(), k -> new ArrayList()).add(this.storage.size() - 1);
        }
    }

    public Map<ResourceLocation, List<Integer>> getTypeIdIndexMap() {
        return this.typeIdIndex;
    }

    public Optional<List<Integer>> getTypeIdIndexList(ResourceLocation typeId) {
        return Optional.ofNullable(this.typeIdIndex.get(typeId)).filter(list -> !list.isEmpty());
    }
}

