/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.ClientTooltipFlag;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class FluidStackType
implements IStackType<FluidStack> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/fluid");
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private FluidStack stack;
    private long stackSize;

    public FluidStackType() {
        this.stack = FluidStack.EMPTY;
        this.stackSize = 0L;
    }

    public FluidStackType(FluidStack stack) {
        this.stack = stack;
        this.stackSize = stack.getAmount();
    }

    public FluidStackType(FluidStack stack, long stackSize) {
        this.stack = stack;
        this.stackSize = stackSize;
    }

    @Override
    public IStackType<FluidStack> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof Fluid) {
            Fluid fluid = (Fluid)key;
            FluidStack fluidStack = new FluidStack((Holder)BuiltInRegistries.FLUID.getHolder(BuiltInRegistries.FLUID.getKey((Object)fluid)).get(), 1, dataComponentPatch);
            return new FluidStackType(fluidStack, amount);
        }
        return null;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<FluidStack> getEmpty() {
        return new FluidStackType();
    }

    @Override
    public FluidStack getStack() {
        this.stack.setAmount(BDMath.clampLongToInt(this.stackSize));
        return this.stack;
    }

    @Override
    public void setStack(FluidStack stack) {
        this.stack = stack.copy();
        this.stackSize = stack.getAmount();
    }

    @Override
    public Class<FluidStack> getStackClass() {
        return FluidStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Fluid.class;
    }

    @Override
    public Object getSource() {
        return FluidStack.EMPTY.getFluid();
    }

    @Override
    public String getModId() {
        return BuiltInRegistries.FLUID.getKey((Object)this.stack.getFluid()).getNamespace();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty() || this.stackSize <= 0L;
    }

    @Override
    public boolean isEmptyStack() {
        return this.stack.isEmpty();
    }

    @Override
    public FluidStack getEmptyStack() {
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack copyStack() {
        return this.stack.copyWithAmount(BDMath.clampLongToInt(this.stackSize));
    }

    @Override
    public FluidStack copyStackWithCount(long count) {
        return this.stack.copyWithAmount(BDMath.clampLongToInt(count));
    }

    @Override
    public IStackType<FluidStack> copy() {
        return new FluidStackType(this.stack.copy(), this.stackSize);
    }

    @Override
    public IStackType<FluidStack> copyWithCount(long count) {
        return new FluidStackType(this.stack.copy(), count);
    }

    @Override
    public long getStackAmount() {
        return this.stackSize;
    }

    @Override
    public void setStackAmount(long amount) {
        this.stackSize = amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min(64000L, this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public FluidStack splitStack(long amount) {
        if (amount <= 0L) {
            return FluidStack.EMPTY;
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, this.stackSize));
        FluidStack split = this.stack.copy();
        split.setAmount(splitAmount);
        this.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<FluidStack> split(long amount) {
        if (amount <= 0L) {
            return new FluidStackType();
        }
        long splitAmount = Math.min(amount, this.stackSize);
        FluidStack split = this.stack.copy();
        this.shrink(splitAmount);
        return new FluidStackType(split, splitAmount);
    }

    @Override
    public boolean isSame(IStackType<FluidStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return FluidStack.isSameFluid((FluidStack)this.stack, (FluidStack)other.copyStackWithCount(1L));
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<FluidStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)this.stack, (FluidStack)other.copyStackWithCount(1L));
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        boolean hasItem = !this.stack.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.writeVarLong(this.stackSize);
            FluidStack copy = this.stack.copyWithAmount(1);
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)copy);
        }
    }

    @Override
    public IStackType<FluidStack> deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new FluidStackType(FluidStack.EMPTY);
        }
        long count = buf.readVarLong();
        FluidStack stack = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        return new FluidStackType(stack, count);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putLong("Amount", this.getStackAmount());
        tag.put("Stack", this.stack.copyWithAmount(1).save(levelRegistryAccess));
        return tag;
    }

    @Override
    public IStackType<FluidStack> deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        FluidStackType stack = new FluidStackType(FluidStack.parseOptional((HolderLookup.Provider)levelRegistryAccess, (CompoundTag)nbt.getCompound("Stack")));
        stack.setStackAmount(nbt.getLong("Amount"));
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        IClientFluidTypeExtensions renderProperties;
        ResourceLocation fluidStill;
        Optional<TextureAtlasSprite> fluidStillSprite;
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        Fluid fluid = this.stack.getFluid();
        if (!fluid.isSame(Fluids.EMPTY) && (fluidStillSprite = Optional.ofNullable(fluidStill = (renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid)).getStillTexture(this.stack)).map(f -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(f)).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation())).isPresent()) {
            int fluidColor = IClientFluidTypeExtensions.of((Fluid)this.stack.getFluid()).getTintColor();
            IngredientRenderer.drawTiledSprite(gui, 16, 16, fluidColor, 16L, fluidStillSprite.get(), x, y);
        }
        poseStack.popPose();
        String countText = this.getCountText(this.stackSize);
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!this.stack.isEmpty()) {
            gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.popPose();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatBucket(count);
    }

    @Override
    public Component getDisplayName() {
        return this.stack.getHoverName();
    }

    @Override
    public List<Component> getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (this.stack.isEmpty()) {
            return List.of(Component.empty());
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Fluid fluid = this.stack.getFluid();
        Component displayName = this.getDisplayName();
        tooltips.add(displayName);
        ResourceLocation resourceLocation = BuiltInRegistries.FLUID.getKey((Object)fluid);
        if (resourceLocation != null) {
            Optional container;
            if (tooltipFlag.isAdvanced()) {
                MutableComponent advancedId = Component.literal((String)resourceLocation.toString()).withStyle(ChatFormatting.DARK_GRAY);
                tooltips.add((Component)advancedId);
            }
            MutableComponent modName = (container = ModList.get().getModContainerById(resourceLocation.getNamespace())).isPresent() ? Component.literal((String)((ModContainer)container.get()).getModInfo().getDisplayName()).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC) : ((container = ModList.get().getModContainerById(resourceLocation.getNamespace().replace('_', '-'))).isPresent() ? Component.literal((String)((ModContainer)container.get()).getModInfo().getDisplayName()).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC) : Component.literal((String)WordUtils.capitalizeFully((String)resourceLocation.getNamespace().replace('_', ' '))).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
            tooltips.add((Component)modName);
        }
        tooltips.add((Component)Component.translatable((String)"istack.beyonddimensions.storage_num.fluid", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return !this.stack.has(DataComponents.HIDE_TOOLTIP) && !this.stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((BundleContents)this.stack.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new) : Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        gui.renderTooltip(minecraft.font, this.getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)minecraft.player, ClientTooltipFlag.of((TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(), ItemStack.EMPTY, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof FluidStackType) {
            FluidStackType otherStack = (FluidStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        return FluidStack.hashFluidAndComponents((FluidStack)this.stack.copyWithAmount(1));
    }
}

