/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyStorage
implements IEnergyStorage {
    private DimensionsNet net;
    private long energyStorage;
    private final long capacity = Long.MAX_VALUE;
    private final int maxTransfer = Integer.MAX_VALUE;

    public EnergyStorage(DimensionsNet net) {
        this.net = net;
        this.energyStorage = 0L;
    }

    public long getRealEnergyStored() {
        return this.energyStorage;
    }

    public long getRealEnergyCapacity() {
        return Long.MAX_VALUE;
    }

    public long getMaxTransfer() {
        return Integer.MAX_VALUE;
    }

    public void setEnergyDirectly(long value) {
        this.energyStorage = Math.max(0L, Math.min(value, Long.MAX_VALUE));
    }

    private void OnChange() {
        this.net.setDirty();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putLong("Energy", this.energyStorage);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider levelRegistryAccess, CompoundTag tag) {
        if (tag.contains("Energy")) {
            this.energyStorage = tag.getLong("Energy");
        }
    }

    public int receiveEnergy(int amount, boolean simulate) {
        long accepted = Math.min(Long.MAX_VALUE - this.energyStorage, (long)Math.min(Integer.MAX_VALUE, amount));
        if (!simulate) {
            this.energyStorage += accepted;
            this.OnChange();
        }
        return (int)accepted;
    }

    public int extractEnergy(int amount, boolean simulate) {
        long extracted = Math.min(this.energyStorage, (long)Math.min(Integer.MAX_VALUE, amount));
        if (!simulate) {
            this.energyStorage -= extracted;
            this.OnChange();
        }
        return (int)extracted;
    }

    public int getEnergyStored() {
        return this.energyStorage > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.energyStorage;
    }

    public int getMaxEnergyStored() {
        return 0x7FFFFFFE;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

