/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Registry.StackTypeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class UnifiedStorage
implements IStackTypedHandler {
    private DimensionsNet net;
    private final ArrayList<IStackType> storage = new ArrayList();
    private final Map<IStackType, Integer> stackIndex = new HashMap<IStackType, Integer>();
    private final Map<ResourceLocation, List<Integer>> typeIdIndex = new HashMap<ResourceLocation, List<Integer>>();
    public static final Map<ResourceLocation, Function<UnifiedStorage, Object>> typedHandlerMap = new HashMap<ResourceLocation, Function<UnifiedStorage, Object>>();

    public UnifiedStorage(DimensionsNet net) {
        this.net = net;
    }

    @Override
    public void onChange() {
        this.net.setDirty();
    }

    @Override
    public Object getTypedHandler(ResourceLocation typeId) {
        return typedHandlerMap.get(typeId).apply(this);
    }

    @Override
    public int getSlots() {
        return this.storage.size();
    }

    @Override
    public IStackType getStackBySlot(int slot) {
        return IStackTypedHandler.super.getStackBySlot(slot);
    }

    @Override
    public List<IStackType> getStorage() {
        return Collections.unmodifiableList(this.storage);
    }

    @Override
    public void clearStorage() {
        this.storage.clear();
        this.typeIdIndex.clear();
        this.stackIndex.clear();
        this.onChange();
    }

    @Override
    public boolean hasStackType(IStackType other) {
        return this.stackIndex.containsKey(other);
    }

    @Override
    public void setStackDirectly(int slot, IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        ResourceLocation oldTypeId = this.getStorage().get(slot).getTypeId();
        this.storage.set(slot, stack.copy());
        this.typeIdIndex.computeIfAbsent(oldTypeId, k -> new ArrayList()).remove((Object)slot);
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        if (!this.stackIndex.containsKey(stack)) {
            this.stackIndex.remove(this.getStackBySlot(slot));
            this.stackIndex.put(stack.copyWithCount(1L), slot);
        }
        this.onChange();
    }

    @Override
    public void addStackToIndexDirectly(int slot, IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        this.storage.add(slot, stack.copy());
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        if (!this.stackIndex.containsKey(stack)) {
            this.stackIndex.put(stack.copyWithCount(1L), slot);
        }
        this.onChange();
    }

    @Override
    public void addStackDirectly(IStackType stack) {
        ResourceLocation newTypeId = stack.getTypeId();
        int slot = this.storage.size();
        this.storage.add(stack.copy());
        this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
        if (!this.stackIndex.containsKey(stack)) {
            this.stackIndex.put(stack.copyWithCount(1L), slot);
        }
        this.onChange();
    }

    @Override
    public IStackType getStackByStack(IStackType stackType) {
        if (this.stackIndex.containsKey(stackType)) {
            return this.getStackBySlot(this.stackIndex.get(stackType));
        }
        return null;
    }

    @Override
    public long getSlotCapacity(int slot) {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isStackValid(int slot, IStackType stack) {
        return true;
    }

    @Override
    public IStackType insert(int slot, IStackType stack, boolean simulate) {
        return this.insert(stack, simulate);
    }

    @Override
    public IStackType insert(IStackType stack, boolean simulate) {
        if (stack.isEmpty()) {
            return StackCreater.CreateEmpty(stack.getTypeId());
        }
        long remaining = stack.getStackAmount();
        long canInsert = Math.min(this.getSlotCapacity(0), stack.getCustomMaxStackSize());
        if (this.stackIndex.containsKey(stack)) {
            IStackType existing = this.storage.get(this.stackIndex.get(stack));
            long actualInsert = Math.min(remaining, canInsert -= existing.getStackAmount());
            remaining -= actualInsert;
            if (!simulate) {
                existing.grow(actualInsert);
                this.onChange();
            }
            return stack.copyWithCount(remaining);
        }
        long actualInsert = Math.min(remaining, canInsert);
        remaining -= actualInsert;
        if (!simulate) {
            IStackType newStack = stack.copyWithCount(actualInsert);
            this.storage.add(newStack);
            int newIndex = this.storage.size() - 1;
            this.typeIdIndex.computeIfAbsent(stack.getTypeId(), k -> new ArrayList()).add(newIndex);
            this.stackIndex.put(stack.copyWithCount(1L), newIndex);
            this.onChange();
        }
        return stack.copyWithCount(remaining);
    }

    @Override
    public IStackType extract(IStackType stack, boolean simulate) {
        int storageIndex;
        IStackType existing;
        if (stack.isEmpty()) {
            return stack.getEmpty();
        }
        List<Integer> indices = this.typeIdIndex.get(stack.getTypeId());
        if (this.stackIndex.containsKey(stack) && (existing = this.storage.get(storageIndex = this.stackIndex.get(stack).intValue())).isSameTypeSameComponents(stack)) {
            long extracted = Math.min(stack.getStackAmount(), existing.getStackAmount());
            IStackType sim = existing.copy();
            IStackType result = sim.split(extracted);
            if (!simulate) {
                existing.shrink(extracted);
                if (existing.getStackAmount() <= 0L) {
                    this.storage.remove(storageIndex);
                    indices.remove((Object)storageIndex);
                    this.stackIndex.remove(stack);
                    this.updateIndicesAfterRemoval(storageIndex);
                    if (indices.isEmpty()) {
                        this.typeIdIndex.remove(stack.getTypeId());
                    }
                }
                this.onChange();
            }
            return result;
        }
        return stack.getEmpty();
    }

    private void updateIndicesAfterRemoval(int removedIndex) {
        for (List<Integer> list : this.typeIdIndex.values()) {
            for (int i = 0; i < list.size(); ++i) {
                int currentIndex = list.get(i);
                if (currentIndex <= removedIndex) continue;
                list.set(i, currentIndex - 1);
            }
        }
        for (Map.Entry entry : this.stackIndex.entrySet()) {
            int currentIndex = (Integer)entry.getValue();
            if (currentIndex <= removedIndex) continue;
            entry.setValue(currentIndex - 1);
        }
    }

    public void rebuildAllIndices() {
        this.typeIdIndex.clear();
        this.stackIndex.clear();
        for (int i = 0; i < this.storage.size(); ++i) {
            IStackType stack = this.storage.get(i);
            if (stack == null || stack.isEmpty()) continue;
            ResourceLocation typeId = stack.getTypeId();
            this.typeIdIndex.computeIfAbsent(typeId, k -> new ArrayList()).add(i);
            this.stackIndex.put(stack.copyWithCount(1L), i);
        }
    }

    @Override
    public IStackType extract(int slot, long amount, boolean simulate) {
        if (slot < 0 || slot >= this.storage.size()) {
            return null;
        }
        IStackType existing = this.storage.get(slot);
        if (existing.isEmpty()) {
            return existing.getEmpty();
        }
        long extracted = Math.min(amount, existing.getStackAmount());
        IStackType sim = existing.copy();
        IStackType result = sim.split(extracted);
        if (!simulate) {
            existing.shrink(extracted);
            if (existing.getStackAmount() <= 0L) {
                ResourceLocation typeId = existing.getTypeId();
                this.storage.remove(slot);
                this.stackIndex.remove(existing);
                List<Integer> indices = this.typeIdIndex.get(typeId);
                if (indices != null) {
                    indices.remove((Object)slot);
                    if (indices.isEmpty()) {
                        this.typeIdIndex.remove(typeId);
                    }
                }
                this.updateIndicesAfterRemoval(slot);
                this.onChange();
            }
        }
        return result;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag stacksTag = new ListTag();
        for (IStackType stack : this.storage) {
            if (stack.isEmpty()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.put("TypedStack", (Tag)stack.serializeNBT(provider));
            stackTag.putString("Type", stack.getTypeId().toString());
            stacksTag.add((Object)stackTag);
        }
        tag.put("Stacks", (Tag)stacksTag);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.storage.clear();
        this.typeIdIndex.clear();
        ListTag stacksTag = tag.getList("Stacks", 10);
        for (Tag t : stacksTag) {
            CompoundTag stackTag = (CompoundTag)t;
            ResourceLocation typeId = ResourceLocation.parse((String)stackTag.getString("Type"));
            IStackType stackEmpty = StackTypeRegistry.getType(typeId).copy();
            IStackType stackActual = stackEmpty.deserializeNBT(stackTag.getCompound("TypedStack"), provider);
            if (stackActual.isEmpty()) continue;
            this.storage.add(stackActual);
            this.typeIdIndex.computeIfAbsent(typeId, k -> new ArrayList()).add(this.storage.size() - 1);
            this.stackIndex.put(stackActual, this.storage.size() - 1);
        }
    }

    public Map<ResourceLocation, List<Integer>> getTypeIdIndexMap() {
        return this.typeIdIndex;
    }

    public Optional<List<Integer>> getTypeIdIndexList(ResourceLocation typeId) {
        return Optional.ofNullable(this.typeIdIndex.get(typeId)).filter(list -> !list.isEmpty());
    }
}

