/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI.SharedWidget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ScrollBar
extends AbstractWidget {
    private final Logger LOGGER = LogUtils.getLogger();
    protected ResourceLocation SPRITE;
    protected int maxScrollLength = 0;
    public int currentPosition = 0;
    public int maxPosition = 0;
    private double dragHold = 0.0;
    private boolean isDragging = false;
    private int startY;

    public ScrollBar(int x, int y, int width, int height, ResourceLocation sprite, int maxScrollLength, int currentPosition, int maxPosition, Component message) {
        super(x, y, width, height, message);
        this.SPRITE = sprite;
        this.maxScrollLength = maxScrollLength;
        this.currentPosition = currentPosition;
        this.maxPosition = maxPosition;
        this.startY = this.getY();
    }

    public void updateScrollPosition(int currentPosition, int maxPosition) {
        this.currentPosition = currentPosition;
        this.maxPosition = maxPosition;
    }

    public int customDragAction(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return 0;
        }
        if (this.maxPosition != 0 && this.isDragging) {
            this.dragHold += dragY;
            double scrollhold = (double)this.maxScrollLength / (double)this.maxPosition / 1.5;
            if (this.dragHold > scrollhold || this.dragHold < -scrollhold) {
                double drag = this.dragHold;
                this.dragHold = 0.0;
                if (drag > 0.0) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible) {
            boolean flag;
            if (this.isValidClickButton(button) && (flag = this.clicked(mouseX, mouseY))) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.onClick(mouseX, mouseY, button);
                this.LOGGER.info("\u70b9\u51fb\u4e8b\u4ef6\u6355\u83b7");
                this.isDragging = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public void onRelease(double mouseX, double mouseY) {
        this.LOGGER.info("\u91ca\u653e\u4e8b\u4ef6\u6355\u83b7");
        this.isDragging = false;
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        int scrollerOffset = this.maxPosition != 0 ? (int)((float)this.maxScrollLength * ((float)this.currentPosition / (float)this.maxPosition)) : 0;
        this.setY(this.startY + scrollerOffset);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(this.SPRITE, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"beyonddimensions.scrollbar.usage.focused"));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"beyonddimensions.scrollbar.usage.hovered"));
            }
        }
    }
}

