/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.JEI;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferHandler
implements IRecipeTransferHandler<DimensionsCraftMenu, RecipeHolder<CraftingRecipe>> {
    public Class<? extends DimensionsCraftMenu> getContainerClass() {
        return DimensionsCraftMenu.class;
    }

    public Optional<MenuType<DimensionsCraftMenu>> getMenuType() {
        return Optional.of(DimensionsCraftMenu.Dimensions_Craft_Menu.get());
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(DimensionsCraftMenu container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        boolean bl;
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.INPUT)) {
            if (slotView.getRole() != RecipeIngredientRole.INPUT) continue;
            Ingredient merged = Ingredient.of((Stream)slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK));
            ingredients.add(merged != null ? merged : Ingredient.EMPTY);
        }
        ArrayList<ItemStack> inputElements = new ArrayList<ItemStack>();
        List<Slot> craftingSlots = this.getInputSources(container);
        List<IStackType> storageSlots = container.storage.getStorage();
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        for (Slot slot : craftingSlots) {
            if (!slot.hasItem()) continue;
            availableItems.add(slot.getItem().copy());
        }
        for (IStackType iStackType : storageSlots) {
            ItemStackType itemStackType;
            ItemStack stack;
            if (!(iStackType instanceof ItemStackType) || (stack = (itemStackType = (ItemStackType)iStackType).getStack()).isEmpty()) continue;
            availableItems.add(stack.copy());
        }
        ArrayList<ItemStack> virtualInventory = new ArrayList<ItemStack>();
        for (ItemStack stack : availableItems) {
            virtualInventory.add(stack.copy());
        }
        boolean bl2 = true;
        block4: for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) {
                inputElements.add(ItemStack.EMPTY);
                continue;
            }
            int required = 1;
            ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
            for (ItemStack stack : virtualInventory) {
                if (stack.isEmpty() || !ingredient.test(stack)) continue;
                matching.add(stack);
            }
            int available = matching.stream().mapToInt(ItemStack::getCount).sum();
            if (available >= required) {
                ItemStack merged = matching.isEmpty() ? ItemStack.EMPTY : new ItemStack((ItemLike)((ItemStack)matching.get(0)).getItem(), required);
                inputElements.add(merged);
                int remaining = required;
                for (ItemStack stack : matching) {
                    int deduct = Math.min(remaining, stack.getCount());
                    stack.shrink(deduct);
                    if ((remaining -= deduct) > 0) continue;
                    continue block4;
                }
                continue;
            }
            bl = false;
            break;
        }
        if (!bl) {
            if (doTransfer) {
                player.displayClientMessage((Component)Component.translatable((String)"beyonddimensions.message.insufficient_materials"), true);
            }
            return new IRecipeTransferError(this){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }
            };
        }
        if (doTransfer) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RecipeFillC2SPacket(inputElements), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return null;
    }

    private List<Slot> getInputSources(DimensionsCraftMenu menu) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = menu.craftSlotStartIndex; i < menu.craftSlotEndIndex; ++i) {
            slots.add(menu.getSlot(i));
        }
        return slots;
    }
}

