/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.FluidHandlerWrapper;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import com.wintercogs.beyonddimensions.Unit.InventoryHelper;
import com.wintercogs.beyonddimensions.Unit.StackHandlerWrapperHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public abstract class BDOrderedContainerMenu
extends BDBaseMenu {
    protected BDOrderedContainerMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, @Nullable IStackTypedHandler storage) {
        super(menuType, containerId, playerInventory, storage);
    }

    @Override
    protected ItemStack quickMoveHandle(Player player, int slotIndex, IStackType clickStack, IStackTypedHandler storage) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && !clickStack.isEmpty()) {
            ItemStack cacheStack;
            if (slot instanceof StoredStackSlot) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickedItem = (ItemStackType)clickStack;
                    cacheStack = clickedItem.copyStack();
                    int moveCount = this.checkCanMoveStackCount(cacheStack, this.inventoryStartIndex, this.inventoryEndIndex, true);
                    moveCount = Math.min(moveCount, cacheStack.getCount());
                    int nowCount = 0;
                    IStackType typedStack = storage.getStackBySlot(slot.getSlotIndex());
                    if (typedStack == null) {
                        return ItemStack.EMPTY;
                    }
                    ItemStack nowStack = (ItemStack)typedStack.getStack();
                    if (nowStack != null) {
                        nowCount = nowStack.getCount();
                    }
                    if ((moveCount = Math.min(moveCount, nowCount)) >= 0) {
                        cacheStack.setCount(moveCount);
                        if (!this.moveItemStackTo(cacheStack, this.inventoryStartIndex, this.inventoryEndIndex, true)) {
                            return ItemStack.EMPTY;
                        }
                        storage.extract(slot.getSlotIndex(), moveCount, false);
                    }
                } else {
                    cacheStack = ItemStack.EMPTY;
                }
            } else if (slot instanceof ResultSlot) {
                ItemStack craftStack;
                ResultSlot resultSlot = (ResultSlot)slot;
                cacheStack = slot.getItem().copy();
                for (int i = 0; !slot.getItem().isEmpty() && i < slot.getItem().getMaxStackSize() / slot.getItem().getCount() && ItemStack.isSameItemSameComponents((ItemStack)cacheStack, (ItemStack)(craftStack = slot.getItem().copy())); ++i) {
                    ItemStack remaining = InventoryHelper.transferToPlayerInventory(player, craftStack);
                    if (!remaining.isEmpty()) {
                        remaining = (ItemStack)storage.insert(StackCreater.Create(ItemStackType.ID, remaining, remaining.getCount()), false).copyStack();
                    }
                    craftStack = slot.getItem().copy();
                    if (!remaining.isEmpty()) continue;
                    resultSlot.onTake(player, craftStack);
                }
            } else {
                cacheStack = slot.getItem().copy();
                int remaining = (int)storage.insert(StackCreater.Create(ItemStackType.ID, cacheStack.copy(), cacheStack.getCount()), false).getStackAmount();
                slot.tryRemove(cacheStack.getCount() - remaining, Integer.MAX_VALUE, player);
            }
            if (cacheStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected void clickHandle(int slotIndex, IStackType clickStack, int button, Player player, IStackTypedHandler storage) {
        ItemStack carriedItem = this.getCarried().copy();
        StoredStackSlot slot = (StoredStackSlot)((Object)this.slots.get(slotIndex));
        if (clickStack.isEmpty()) {
            if (!carriedItem.isEmpty()) {
                AtomicBoolean handled = new AtomicBoolean(false);
                if (carriedItem.getCount() == 1 && button == 1) {
                    Item item = carriedItem.getItem();
                    if (item instanceof BucketItem) {
                        FluidStackType stack;
                        FluidHandlerWrapper stackHandlerWrapper;
                        BucketItem bucketItem = (BucketItem)item;
                        Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                        if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty()) {
                            int changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize());
                            int remaining = (int)storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), true).getStackAmount();
                            if (remaining <= 0) {
                                storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount();
                                this.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                                handled.set(true);
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(cap);
                            if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                    int remaining;
                                    int changedCount;
                                    int actualInsert;
                                    IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(index));
                                    if (stack == null || stack.isEmpty() || (actualInsert = (changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize())) - (remaining = (int)storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount())) <= 0) continue;
                                    long actualExtracts = stackHandlerWrapper.extract(index, actualInsert, false);
                                    if (actualExtracts < (long)actualInsert) {
                                        storage.extract(slot.getSlotIndex(), (long)actualInsert - actualExtracts, false);
                                    }
                                    this.setCarried(carriedItem.copy());
                                    handled.set(true);
                                    break;
                                }
                            }
                        });
                    }
                }
                if (!handled.get()) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    int remaining = (int)storage.insert(slot.getSlotIndex(), StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false).getStackAmount();
                    int actualInsert = changedCount - remaining;
                    int newCount = carriedItem.getCount() - actualInsert;
                    if (newCount <= 0) {
                        this.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.setCarried(newCarriedItem);
                    }
                }
            }
        } else if (slot.mayPickup(player)) {
            if (carriedItem.isEmpty()) {
                if (clickStack instanceof ItemStackType) {
                    ItemStackType clickItem = (ItemStackType)clickStack;
                    int woundChangeNum = (int)Math.min(clickItem.getStackAmount(), clickItem.getVanillaMaxStackSize());
                    int actualChangeNum = button == 0 ? woundChangeNum : (woundChangeNum + 1) / 2;
                    ItemStack takenItem = ((ItemStack)storage.extract(slot.getSlotIndex(), actualChangeNum, false).getStack()).copy();
                    if (takenItem != null) {
                        this.setCarried(takenItem);
                        storage.onChange();
                    }
                }
            } else if (slot.mayPlace(carriedItem)) {
                if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                    int changedCount = button == 0 ? carriedItem.getCount() : 1;
                    int remaining = (int)storage.insert(slot.getSlotIndex(), StackCreater.Create(ItemStackType.ID, carriedItem.copyWithCount(changedCount), changedCount), false).getStackAmount();
                    int actualInsert = changedCount - remaining;
                    int newCount = carriedItem.getCount() - actualInsert;
                    if (newCount <= 0) {
                        this.setCarried(ItemStack.EMPTY);
                    } else {
                        ItemStack newCarriedItem = carriedItem.copy();
                        newCarriedItem.setCount(newCount);
                        this.setCarried(newCarriedItem);
                    }
                } else if (carriedItem.getCount() == 1 && button == 1) {
                    Item remaining = carriedItem.getItem();
                    if (remaining instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)remaining;
                        if (bucket == Items.BUCKET) {
                            FluidStackType fluidStackType;
                            Item filledBucket;
                            if (clickStack instanceof FluidStackType && (filledBucket = (fluidStackType = (FluidStackType)clickStack).getStack().getFluid().getBucket()) != null && filledBucket != Items.AIR && fluidStackType.getStackAmount() >= 1000L) {
                                storage.extract(slot.getSlotIndex(), 1000L, false);
                                this.setCarried(new ItemStack((ItemLike)filledBucket));
                            }
                        } else {
                            FluidStackType stack;
                            FluidHandlerWrapper stackHandlerWrapper;
                            Object handler = carriedItem.getCapability(Capabilities.FluidHandler.ITEM);
                            if (handler != null && (stackHandlerWrapper = new FluidHandlerWrapper(handler)).getSlots() > 0 && (stack = new FluidStackType(stackHandlerWrapper.getStackInSlot(0))) != null && !stack.isEmpty()) {
                                int changedCount = (int)Math.min(stack.getStackAmount(), stack.getVanillaMaxStackSize());
                                int remaining2 = (int)storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), true).getStackAmount();
                                if (remaining2 <= 0) {
                                    storage.insert(slot.getSlotIndex(), stack.copyWithCount(changedCount), false).getStackAmount();
                                    this.setCarried(new ItemStack((ItemLike)Items.BUCKET));
                                }
                            }
                        }
                    } else {
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler;
                            if (clickStack.getTypeId().equals(typeId) && (handler = carriedItem.getCapability(cap)) != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                IStackType trueStack = storage.getStackBySlot(slot.getSlotIndex());
                                long tureCount = 0L;
                                if (trueStack.isSameTypeSameComponents(clickStack)) {
                                    tureCount = trueStack.getStackAmount();
                                }
                                int changedCount = (int)Math.min(tureCount, clickStack.getVanillaMaxStackSize());
                                int remaining = (int)stackHandlerWrapper.insert(clickStack.copyStack(), false);
                                int actualInsert = changedCount - remaining;
                                storage.extract(slot.getSlotIndex(), actualInsert, false);
                                this.setCarried(carriedItem.copy());
                            }
                        });
                    }
                }
            } else if (clickStack.isSameTypeSameComponents(new ItemStackType(carriedItem.copy()))) {
                // empty if block
            }
        }
    }
}

